<?php
// ++=========================================================================++
// || vBadvanced CMPS v4.1.2 (vB 4.0 - 4.1) - 137094
// ||  2003-2011 vBadvanced.com - All Rights Reserved
// || This file may not be redistributed in whole or significant part.
// || http://vbadvanced.com
// || Downloaded 10:06, Wed Sep 7th 2011
// || 520137094_407329059488
// ++ ========================================================================++

error_reporting(E_ALL & ~E_NOTICE & ~8192);

require_once('./global.php');
require_once(DIR . '/includes/adminfunctions_template.php');
require_once(DIR . '/includes/adminfunctions_language.php');
require_once(DIR . '/includes/vba_cmps_adminfunctions.php');

$scriptname = 'CMPS';
$scriptfile = 'vbacmps_install';

define('PRODUCT_CODE', 'adv_cmps');

print_cp_header('vBadvanced ' . $scriptname . ' Install', '', '<style type="text/css">
<!--
.redalert
{
	background: #FF0000;
	color: #000000;
}
-->
</style>');

// ##### Check version
if (substr($vbulletin->options['templateversion'], 0, 2) != '4.' OR !is_object($db))
{
	echo 'It appears that you are trying to install vBadvanced ' . $scriptname . ' on an older version of vBulletin (3.x or prior).<br />You must upgrade to vBulletin 4.0.0 or higher before proceeding.';
	exit;
}

if (!$_REQUEST['do'])
{
	$_REQUEST['do'] = 'installstart';
}

?>

<script type="text/javascript">
<!--

function safeSubmit(formobj)
{
	if (document.all || document.getElementById)
	{
		for (i = 0; i < formobj.length; i++)
		{
			var tempobj = formobj.elements[i];
			if (tempobj.type == 'submit')
			{
				tempobj.disabled = true;
			}
		}
	}
}
-->
</script>

<?php

// ##################### Delete Template Function #####################
function kill_template($title, $printphrase = 0)
{
	global $db;

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title = '$title'");

	return '<div>Removed template ' . $title . '</div>';
}

// ##### Insert all templates #################################################
function insert_all_templates()
{
	global $maintemplates, $db, $vbulletin, $version;

	$noupdate = array();
	$getcurrent = $vbulletin->db->query_read("
		SELECT title, template_un
		FROM " . TABLE_PREFIX . "template
		WHERE title IN('" . implode("', '", array_keys($maintemplates)) . "')
			AND styleid = '-1'
	");
	while ($current = $vbulletin->db->fetch_array($getcurrent))
	{
		if ($maintemplates[$current['title']] == stripslashes($current['template_un']))
		{
			$noupdate[] = $current['title'];
		}
	}

	$newtemps = array_diff(array_keys($maintemplates), $noupdate);

	if (empty($newtemps))
	{
		return false;
	}

	$vbulletin->db->query_write("
		DELETE FROM " . TABLE_PREFIX . "template
		WHERE title IN('" . implode("', '", $newtemps) . "')
		AND styleid = '-1'
	");

	foreach ($newtemps AS $name)
	{
		$content = $maintemplates[$name];

		$tempinsert .= "(
			'$name',
			'" . $db->escape_string(compile_template($content)) . "',
			'" . $db->escape_string($content) ."',
			'-1',
			'template',
			" . TIMENOW . ",
			'vBadvanced',
			'" . $version . "',
			'" . PRODUCT_CODE . "'
		),";
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "template
			(title, template, template_un, styleid, templatetype, dateline, username, version, product)
		VALUES
			" . substr($tempinsert, 0, strlen($tempinsert) - 1)
	);

}

// ##################### Insert Settings Function #####################
function insert_setting()
{
	global $db, $varname, $setting, $grouptitle;

	if (!$varname)
	{
		return false;
	}

	$checksetting = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	if ($checksetting['varname'])
	{
		return false;
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_setting
			(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
		VALUES (
			'$varname',
			'" . $grouptitle . "',
			'" . $db->escape_string($setting['value']) . "',
			'" . $db->escape_string($setting['value']) . "',
			'" . $db->escape_string($setting['optioncode']) . "',
			" . $setting['displayorder'] . ",
			'$setting[serialize]'
	)");

	$phrasetypeid = 'vbsettings';

	return '<div>Added Setting - ' . $title . '</div>';

}

// ##################### Update Settings Function #####################
function update_setting($phraseonly = false)
{
	global $db, $varname, $setting, $grouptitle;

	if (!$varname)
	{
		return false;
	}

	$oldvarname = $varname;

	$phrasetypeid = 'vbsettings';

	// Title phrase
	update_phrase('setting_' . $varname . '_title', $setting['title']);

	// Description phrase
	update_phrase('setting_' . $varname . '_desc', $setting['description']);

	if ($phraseonly)
	{
		return false;
	}

	$varname = $oldvarname;

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "adv_setting SET
			defaultvalue = '" . $db->escape_string($setting['value']) . "',
			optioncode = '" . $db->escape_string($setting['optioncode']) . "',
			displayorder = $setting[displayorder],
			grouptitle = '$grouptitle',
			serialize = '$setting[serialize]'
		WHERE varname = '$varname' AND grouptitle = '$grouptitle'
	");

	return '<div>Updated Setting - ' . $varname . '</div>';
}

// ##### Rebuild All Settings #################################################
function rebuild_all_settings()
{
	global $db, $vba_modules, $mainsettings, $adv_settinggroups;
	global $grouptitle, $varname, $setting;

	// Need to update the phrases, so we might as well do it here
	// before we start adding duplicates to $mainsettings
	insert_all_phrases();

	// Settinggroups
	foreach ($adv_settinggroups AS $grouptitle => $order)
	{
		$db->query_write("
			INSERT IGNORE INTO " . TABLE_PREFIX . "adv_settinggroup
				(grouptitle, displayorder)
			VALUES (
				'$grouptitle',
				'$order'
		)");
	}

	// Link up the setting grouptitle by filename
	$modfilenames = array();
	foreach ($vba_modules AS $modid => $module)
	{
		if ($module['identifier'])
		{
			if ($module['parent'])
			{
				$module['filename'] .= '-child';
			}

			$modfilenames[$module['filename']] = $module['identifier'];
		}
	}

	$copiedmods = array();
	$extramods = $db->query_read("
		SELECT identifier, filename, parent
		FROM " . TABLE_PREFIX . "adv_modules
		WHERE identifier NOT IN('" . implode("', '", array_values($modfilenames)) . "')
		 AND filename IN('" . implode("', '", array_keys($modfilenames)) . "')
	");
	while ($emod = $db->fetch_array($extramods))
	{
		// Don't mix up the parent and child module's settings
		if ($emod['parent'])
		{
			$emod['filename'] .= '-child';
		}

		// Merge a new grouptitle into the $mainsettings array
		if (isset($modfilenames[$emod['filename']]) AND !empty($mainsettings['adv_portal_' . $modfilenames[$emod['filename']]]))
		{
			$mainsettings['adv_portal_' . $emod['identifier']] = $mainsettings['adv_portal_' . $modfilenames[$emod['filename']]];
		}
	}

	// Got all the settings, now process them
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		$setcount += sizeof($settings);
		$insertsettings = '';
		$csetting = array();
		$getsettings = $db->query_read("
			SELECT varname FROM " . TABLE_PREFIX . "adv_setting
			WHERE grouptitle = '$grouptitle'
				AND varname IN('" . implode("', '", array_keys($settings)) . "')
		");
		while ($set = $db->fetch_array($getsettings))
		{
			$csetting[] = $set['varname'];

			$setting =& $mainsettings[$grouptitle][$set['varname']];

			// Go ahead and update it
			$db->query_write("
				UPDATE " . TABLE_PREFIX . "adv_setting SET
					defaultvalue = '" . $db->escape_string($setting['value']) . "',
					optioncode = '" . $db->escape_string($setting['optioncode']) . "',
					displayorder = $setting[displayorder],
					grouptitle = '$grouptitle',
					serialize = '$setting[serialize]'
				WHERE varname = '$set[varname]' AND grouptitle = '$grouptitle'
			");
		}
		$csetting = array_diff(array_keys($settings), $csetting);

		// New settings
		if (!empty($csetting))
		{
			foreach ($csetting AS $cvarname)
			{
				$setting =& $mainsettings[$grouptitle][$cvarname];

				$insertsettings .= "(
					'$cvarname',
					'" . $grouptitle . "',
					'" . $db->escape_string($setting['value']) . "',
					'" . $db->escape_string($setting['value']) . "',
					'" . $db->escape_string($setting['optioncode']) . "',
					" . $setting['displayorder'] . ",
					'$setting[serialize]'
				),";
			}
		}

		if ($insertsettings)
		{
			$db->query_write("
				INSERT INTO " . TABLE_PREFIX . "adv_setting
					(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
				VALUES
					" . substr($insertsettings, 0, strlen($insertsettings) - 1)
			);
		}
	}

	build_adv_settings();
}

// ##################### Delete Setting Function #####################
function kill_setting($printphrase = 0)
{
	global $db, $varname, $grouptitle;

	if ($grouptitle == 'adv_global')
	{
		return;
	}

	$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname' AND grouptitle = '$grouptitle'");

	kill_phrase('setting_" . $title . "_title');
	kill_phrase('setting_" . $title . "_desc');

	return '<div>Removed Setting - ' . $title . '</div>';
}

// ##### Insert Phrase Function ###############################################
function insert_phrase($forcevarname = '', $forcetext = '')
{
	global $db, $phrasetypeid, $varname, $text, $version;

	if ($forcevarname)
	{
		$varname = $forcevarname;
		$text = $forcetext;
	}

	kill_phrase();

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product, username, dateline, version)
		VALUES (
			'-1',
			'" . $varname . "',
			'" . $db->escape_string($text) ."',
			'$phrasetypeid',
			'" . PRODUCT_CODE . "',
			'vBadvanced',
			" . TIMENOW . ",
			'$version'
	)");

	return '<div>Added Phrase - ' . $varname . '</div>';
}

// ##### Update Phrase Function ###############################################
function update_phrase($forcevarname = '', $forcetext = '')
{
	global $db, $varname, $text, $phrasetypeid, $version;

	if ($forcevarname)
	{
		$varname = $forcevarname;
		$text = $forcetext;
	}

	// Insert first, just to make sure it's really there
	$db->query_write("
		INSERT IGNORE INTO " . TABLE_PREFIX . "phrase
			(languageid, varname, text, fieldname, product, username, dateline, version)
		VALUES (
			'-1',
			'" . $varname . "',
			'" . $db->escape_string($text) ."',
			'$phrasetypeid',
			'" . PRODUCT_CODE . "',
			'vBadvanced',
			" . TIMENOW . ",
			'$version'
	)");

	$db->query_write("
		UPDATE " . TABLE_PREFIX . "phrase SET
			text = '" . $db->escape_string($text) ."',
			dateline = " . TIMENOW . ",
			version = '$version',
			username = 'vBadvanced'
		WHERE varname = '$varname'
			AND fieldname = '$phrasetypeid'
			AND product = '" . PRODUCT_CODE . "'
			AND languageid = '-1'
	");

	return '<div>Updated Phrase - ' . $varname . '</div>';
}

// ##################### Delete Phrase Function #####################
function kill_phrase($forcevarname = '')
{
	global $db, $varname, $phrasetypeid;

	if ($forcevarname)
	{
		$varname = $forcevarname;
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "phrase
		WHERE varname = '$varname'
			AND fieldname = '$phrasetypeid'
			AND product = '" . PRODUCT_CODE . "'
			AND languageid = '-1'
	");

	return '<div>Removed phrase ' . $varname . '</div>';
}

// ##### Complete Phrase Insert/Delete ########################################
function insert_all_phrases()
{
	global $db, $mainphrases, $mainsettings, $version;

	// Settings phrases
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		foreach ($settings AS $varname => $setting)
		{
			$mainphrases['vbsettings']['setting_' . $varname . '_title'] = $setting['title'];
			$mainphrases['vbsettings']['setting_' . $varname . '_desc'] = $setting['description'];
		}
	}

	// Main phrases
	foreach ($mainphrases AS $fieldname => $phrases)
	{
		$db->query_write("
			DELETE FROM " . TABLE_PREFIX . "phrase
			WHERE fieldname = '$fieldname'
				AND varname IN('" . implode("','", array_keys($phrases)) . "')
				AND languageid = '-1'
		");

		$insertquery = '';
		foreach ($phrases AS $varname => $text)
		{
			$insertquery .= "('-1', '$varname', '" . $db->escape_string($text) . "', '$fieldname', '" . PRODUCT_CODE . "', 'vBadvanced', " . TIMENOW . ", '$version'),";
		}

		$db->query_write("
			INSERT INTO " . TABLE_PREFIX . "phrase
				(languageid, varname, text, fieldname, product, username, dateline, version)
			VALUES
				" . substr($insertquery, 0, strlen($insertquery) - 1)
		);
	}

	build_language(-1);

}

// ##### Print Form Header w/ js to disable button ############################
function print_js_form_header($file, $do)
{
	echo '<form action="' . $file . '.php" method="post" onsubmit="return safeSubmit(this)">
		<input type="hidden" name="adminhash" value="' . ADMINHASH . '" />';

	if ($do)
	{
		echo '<input type="hidden" name="do" value="' . $do . '" />';
	}

	print_table_start();
}

// ##### Install Table Start Function #########################################
function print_install_table_start($title = '', $reqdo = '')
{
	global $scriptfile, $scriptname;

	print_js_form_header($scriptfile, $reqdo);

	if (!$title)
	{
		$title = 'vBadvanced ' . $scriptname . ' Install';
	}

	print_table_header($title);
}

// ##### Install End Table Function ###########################################
function print_install_table_end()
{
	global $stepphrase, $scriptname, $step, $nextstep, $nextdo, $rebuildtemp, $nocontinue, $forumsoff;

	print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');

	if ($_REQUEST['do'] == 'installstart')
	{
		print_description_row('Main Options', false, 2, 'thead');
		print_radio_row('', 'do', array(
				'install' => 'Begin the installation process.',
				'upgrade' => 'Upgrade.',
				'uninstall' => 'Uninstall vBadvanced ' . $scriptname . '.'
			), 'install');

		print_description_row('Maintenance', false, 2, 'thead');
		print_radio_row('', 'do', array(
				'templates' => 'Reinstall the templates.',
				'phrases' => 'Reinstall the phrases.',
				'rebuildsettings' => 'Rebuild the settings',
				'updateplugins' => 'Reinstall the vBulletin plugins.',
				'doimages' => 'Update your image paths.'
			));

	}

	construct_hidden_code('step', iif($nextstep, $nextstep, $step + 1));

	if ($nextdo != 'closeforums')
	{
		construct_hidden_code('forumsoff', $forumsoff);
	}

	if ($nextdo)
	{
		construct_hidden_code('do', $nextdo);
	}

	print_table_break();

	if ($rebuildtemp)
	{
		build_all_styles(0, 0);
	}

	if ($nocontinue)
	{
		print_table_footer();
	}
	else
	{
		print_submit_row('Continue', '');
	}
}

// ##### Check for and add indexes ############################################
function add_table_index($table, $column)
{
	global $db;
	$indexcheck = $db->query("SHOW KEYS FROM " . TABLE_PREFIX . $table);
	while ($icheck = $db->fetch_array($indexcheck))
	{
		if ($icheck['Column_name'] == $column AND $icheck['Seq_in_index'] == 1)
		{
			return;
		}
	}
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "$table ADD INDEX ($column)");
}

// ##### Insert Plugins #######################################################
function insert_plugins()
{
	global $db, $vba_plugins;

	$plugcheck = array();
	$getplugins = $db->query_read("
		SELECT devkey
		FROM " . TABLE_PREFIX . "plugin
		WHERE devkey IN('" . implode("', '", array_keys($vba_plugins)) . "')
			AND product = '" . PRODUCT_CODE . "'
	");
	while ($plugin = $db->fetch_array($getplugins))
	{
		$plugcheck[$plugin['devkey']] = true;
	}

	// Shouldn't ever need to insert php code for this one
	unset($vba_plugins['adv_cmps_integrate_start']['phpcode']);

	foreach ($vba_plugins AS $devkey => $plugin)
	{
		$plugin['devkey'] = $devkey;

		if (!$plugin['product'])
		{
			$plugin['product'] = PRODUCT_CODE;
		}
		$plugin['active'] = 1;

		// Setting this to 3 should prevent problems with vBSEO?
		// adv_cmps_init_startup plugin needs to be executed after adv_cmps_integrate_start

		switch ($devkey)
		{
			case 'adv_cmps_integrate_start':
				$plugin['executionorder'] = 1;
			break;

			case 'adv_cmps_init_startup':
				$plugin['executionorder'] = 2;
			break;

			default:
				$plugin['executionorder'] = 3;
		}

		$db->query_write(fetch_query_sql($plugin, 'plugin', iif($plugcheck[$devkey], "WHERE devkey = '$devkey' AND product = '" . PRODUCT_CODE . "'", '')));
	}

	vBulletinHook::build_datastore($db);
}

// ############################################################################
// Arrays
// ############################################################################

// ##### Templates ############################################################
$maintemplates = array(
'adv_portal' =>
'{vb:stylevar htmldoctype}
<html dir="{vb:stylevar textdirection}" lang="{vb:stylevar languagecode}" xmlns="http://www.w3.org/1999/xhtml">
<head>

{vb:raw headinclude}

<vb:if condition="$pages[\'name\'] == \'home\'">
	<meta http-equiv="Cache-Control" content="no-cache" />
	<meta http-equiv="Pragma" content="no-cache" />
	<meta http-equiv="Expires" content="0" />
</vb:if>

<title>{vb:raw vboptions.hometitle} <vb:if condition="$pagetitle">- {vb:raw pagetitle}</vb:if></title>

{vb:raw headinclude_bottom}

</head>
<body>

{vb:raw header}

{vb:raw navbar}

<vb:if condition="$show[\'customizepagelink\']">
	<div align="{vb:stylevar right}" style="padding-top: {vb:stylevar padding}; padding-bottom: {vb:stylevar padding}">
		<vb:if condition="$show[\'customizepage\']">
			[<a href="javascript: reset_cmps_layout({vb:raw pages.pageid})">{vb:rawphrase reset_layout}</a>] 
			[<a href="{vb:raw show.customizepagelink}">{vb:rawphrase exit_customization_mode}</a>]
		<vb:else />
			[<a href="{vb:raw show.customizepagelink}">{vb:rawphrase customize_this_page}</a>]
		</vb:if>
	</div>
</vb:if>

<table align="center" cellspacing="0" cellpadding="0" width="100%">
	<tr valign="top">
		<vb:if condition="$show[\'left_column\']">
			<td width="{vb:raw vba_style.portal_leftcolwidth}"<vb:if condition="$show[\'center_column\'] OR $show[\'right_column\']"> style="padding-{vb:stylevar right}: {vb:raw vba_style.portal_colspacing}px"</vb:if>>
				{vb:raw home.leftblocks}
			</td>
		</vb:if>
		<vb:if condition="$show[\'center_column\']">
			<td valign="top">
				{vb:raw home.centerblocks}
			</td>
		</vb:if>
		<vb:if condition="$show[\'right_column\']">
			<td valign="top" width="{vb:raw vba_style.portal_rightcolwidth}"<vb:if condition="$show[\'center_column\'] OR $show[\'left_column\']"> style="padding-{vb:stylevar left}: {vb:raw vba_style.portal_colspacing}px"</vb:if>>
				{vb:raw home.rightblocks}
			</td>
		</vb:if>
	</tr>
</table>

{vb:raw footer}

</body>
</html>',


'adv_portal.css' =>
'.vba_module {
	border: {vb:stylevar threadbit_border};
}

.vba_spacer {
	border-bottom: {vb:stylevar threadbit_border};
}

.vba_news {
	margin-top: 4px;
}

.vba_rating1 {
	background-image:url({vb:stylevar imgdir_rating}/rating-trans-15_1.png);
	background-repeat: no-repeat;
	background-position: top {vb:stylevar right};
}
.vba_rating2 {
	background-image:url({vb:stylevar imgdir_rating}/rating-trans-15_2.png);
	background-repeat: no-repeat;
	background-position: top {vb:stylevar right};
}
.vba_rating3 {
	background-image:url({vb:stylevar imgdir_rating}/rating-trans-15_3.png);
	background-repeat: no-repeat;
	background-position: top {vb:stylevar right};
}
.vba_rating4 {
	background-image:url({vb:stylevar imgdir_rating}/rating-trans-15_4.png);
	background-repeat: no-repeat;
	background-position: top {vb:stylevar right};
}
.vba_rating5 {
	background-image:url({vb:stylevar imgdir_rating}/rating-trans-15_5.png);
	background-repeat: no-repeat;
	background-position: top {vb:stylevar right};
}

#forumrules .rules_link {
	padding-{vb:stylevar left}: 40px;
}

.threadbit .threadstats li {
	margin-{vb:stylevar right}: 5px;
}',


'adv_portal_archivebits_exp' =>
'<tr class="vba_module" style="border-right: 0; border-left: 0;">
	<vb:if condition="$mod_options[\'portal_archive_showicon\']">
		<td class="blockrow">
			<vb:if condition="$show[\'threadicon\']">
				<img alt="" border="0" src="{vb:raw news.threadiconpath}" title="{vb:raw news.threadicontitle}" />
			</vb:if>
		</td>
	</vb:if>

	<td class="blockrow" align="{vb:stylevar left}">
		<div<vb:if condition="$news[\'rating\']"> class="vba_rating{vb:raw news.rating}"</vb:if>>
			<a href="{vb:raw vboptions.bburl}/{vb:link thread, {vb:raw news}}" title="{vb:raw news.preview}">{vb:raw news.title}</a>
			<vb:if condition="$mod_options[\'portal_archive_multipage\'] AND $show[\'pagenav\']">
				(<img class="inlineimg" src="{vb:stylevar imgdir_misc}/multipage.gif" border="0" alt="" /> {vb:raw news.pagenav}<vb:if condition="$show[\'pagenavmore\']">... <a href="{vb:raw news.lastpagelink}">{vb:rawphrase last_page}</a></vb:if>)
			</vb:if>
			<vb:if condition="$mod_options[\'portal_archive_threadstarter\']">
	 			<div>
					{vb:rawphrase by_x, {vb:link member, {vb:raw news}, null, \'postuserid\', \'postusername\'}, {vb:raw news.postusername}}
				</div>
			</vb:if>
			<vb:if condition="$news[\'subscribed\'] OR $show[\'paperclip\'] OR ($news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\'])">
				<span style="float:{vb:stylevar right}">
					<vb:if condition="$news[\'subscribed\']">
						<img alt="" class="inlineimg" src="{vb:stylevar imgdir_misc}/subscribed.png" title="{vb:rawphrase you_are_subscribed_to_this_thread}" />
					</vb:if>
					<vb:if condition="$show[\'paperclip\']">
						<a href="#" onclick="vba_attach_win({vb:raw news.threadid}); return false"><img class="inlineimg" src="{vb:stylevar imgdir_misc}/paperclip.png" border="0" title="{vb:rawphrase x_attachments, {vb:raw news.attach}}" alt="" /></a>
					</vb:if>
					<vb:if condition="$news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\']">
						<img class="inlineimg" src="{vb:stylevar imgdir_misc}/sticky.gif" title="{vb:rawphrase sticky_thread}" alt="" />
					</vb:if>
				</span>
			</vb:if>
			<vb:if condition="$mod_options[\'portal_archive_showdate\']">
				<div>{vb:raw news.postdate} <span class="time">{vb:raw news.posttime}</span></div>
			</vb:if>
		</div>
	</td>

	<vb:if condition="$show[\'lastpost\']">
		<td class="blockrow">
			<div style="text-align:{vb:stylevar right}; white-space:nowrap">
				{vb:raw news.lastpostdate} <span class="time">{vb:raw news.lastposttime}</span><br />
				{vb:rawphrase by_x, {vb:link member, {vb:raw news}, null, \'lastposterid\', \'lastposter\'}, {vb:raw news.lastposter}} <a href="{vb:raw vboptions.bburl}/showthread.php?{vb:raw session.sessionurl}p={vb:raw news.lastpostid}{vb:raw news.highlight}<vb:if condition="$news[\'pagenav\']">&amp;page={vb:raw news.totalpages}</vb:if>#post{vb:raw news.lastpostid}"><img alt="" border="0" src="{vb:stylevar imgdir_button}/lastpost-{vb:stylevar right}.png" title="{vb:rawphrase go_to_last_post}" /></a>
			</div>
		</td>
	</vb:if>

	<vb:if condition="$mod_options[\'portal_archive_showreplies\']">
		<td align="center" class="{vb:raw class_reply}">{vb:raw news.replycount}</td>
	</vb:if>
	<vb:if condition="$mod_options[\'portal_archive_showviews\']">
		<td align="center" class="{vb:raw class_view}">{vb:raw news.views}</td>
	</vb:if>
	<vb:if condition="$mod_options[\'portal_newsarchive_showforum\']">
		<td class="{vb:raw class_ftitle}">
			<a href="{vb:raw vboptions.bburl}/{vb:link forum, {vb:raw news}, null, \'forumid\', \'forumtitle\'}">{vb:raw news.forumtitle}</a>
		</td>
	</vb:if>
</tr>',


'adv_portal_archivebits_exp_head' =>
'<tr>
	<vb:if condition="$mod_options[\'portal_archive_showicon\']">
		<td class="blocksubhead" width="15">&nbsp;</td>
	</vb:if>
	<td class="blocksubhead" width="100%">{vb:rawphrase title_username_date}</td>
	<vb:if condition="$show[\'lastpost\']">
		<td align="center" class="blocksubhead" style="white-space: nowrap" width="25%">{vb:rawphrase last_post}</td>
	</vb:if>
	<vb:if condition="$mod_options[\'portal_archive_showreplies\']">
		<td class="blocksubhead" width="15">{vb:rawphrase replies}</td>
	</vb:if>
	<vb:if condition="$mod_options[\'portal_archive_showviews\']">
		<td class="blocksubhead" width="15">{vb:rawphrase views}</td>
	</vb:if>
	<vb:if condition="$mod_options[\'portal_newsarchive_showforum\']">
		<td align="center" class="blocksubhead" width="10%">{vb:rawphrase forum}</td>
	</vb:if>
</tr>',


'adv_portal_archivebits_lean' =>
'<div class="blockrow vba_spacer">
	<vb:if condition="$show[\'paperclip\'] OR ($news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\'])">
		<span style="float:{vb:stylevar right}">
			<vb:if condition="$show[\'paperclip\']">
				<a href="#" onclick="vba_attach_win({vb:raw news.threadid}); return false"><img class="inlineimg" src="{vb:stylevar imgdir_misc}/paperclip.png" border="0" title="{vb:rawphrase x_attachments, {vb:raw news.attach}}" alt="" /></a>
			</vb:if>
			<vb:if condition="$news[\'sticky\'] AND $mod_options[\'portal_archive_stickyicon\']">
				<img class="inlineimg" src="{vb:stylevar imgdir_misc}/sticky.gif" title="{vb:rawphrase sticky_thread}" alt="" />
			</vb:if>
		</span>
	</vb:if>
	<vb:if condition="$news[\'threadiconpath\'] AND $mod_options[\'portal_archive_showicon\']">
		<img alt="" class="inlineimg" src="{vb:raw news.threadiconpath}" border="0" title="{vb:raw news.threadicontitle}" />
	</vb:if>
	<vb:if condition="$news[\'subscribed\'] AND $mod_options[\'portal_archive_showsubscribed\']">
		<img alt="" class="inlineimg" src="{vb:stylevar imgdir_misc}/subscribed.png" title="{vb:rawphrase you_are_subscribed_to_this_thread}" />
	</vb:if>
	<a href="{vb:raw vboptions.bburl}/{vb:link thread, {vb:raw news}}" title="{vb:raw news.preview}">{vb:raw news.title}</a>
	<vb:if condition="$mod_options[\'portal_archive_multipage\'] AND $show[\'pagenav\']">
		(<img class="inlineimg" src="{vb:stylevar imgdir_misc}/multipage.gif" border="0" alt="" /> {vb:raw news.pagenav}<vb:if condition="$show[\'pagenavmore\']">... <a href="{vb:raw news.lastpagelink}">{vb:rawphrase last_page}</a></vb:if>)
	</vb:if>
	<vb:if condition="$mod_options[\'portal_archive_showdate\']">
		<div>{vb:raw news.postdate} <span class="time">{vb:raw news.posttime}</span></div>
	</vb:if>
	<div>
		<vb:if condition="$news[\'rating\']">
			<img src="{vb:stylevar imgdir_rating}/rating-trans-15_{vb:raw news.rating}.png" alt="" />
		</vb:if>
		<vb:if condition="$mod_options[\'portal_archive_threadstarter\']">
			<div>
				{vb:rawphrase by_x, {vb:link member, {vb:raw news}, null, \'postuserid\', \'postusername\'}, {vb:raw news.postusername}}
			</div>
		</vb:if>
		<vb:if condition="$mod_options[\'portal_newsarchive_showforum\']">
			<div style="padding-top:{vb:stylevar cellpadding}px"><a href="{vb:raw vboptions.bburl}/{vb:link forum, {vb:raw news}, null, \'forumid\', \'forumtitle\'}">{vb:raw news.forumtitle}</a></div>
		</vb:if>
		<vb:if condition="$show[\'lastpost\']">
			<div style="padding-top:{vb:stylevar cellpadding}px">
				<a href="{vb:raw vboptions.bburl}/showthread.php?{vb:raw session.sessionurl}p={vb:raw news.lastpostid}{vb:raw news.highlight}<vb:if condition="$news[\'pagenav\']">&amp;page={vb:raw news.totalpages}</vb:if>#post{vb:raw news.lastpostid}"><img class="inlineimg" alt="" border="0" src="{vb:stylevar imgdir_button}/lastpost-{vb:stylevar right}.png" title="{vb:rawphrase go_to_last_post}" /></a> {vb:rawphrase last_post_by} <a href="{vb:raw vboptions.bburl}/{vb:link member, {vb:raw news}, null, \'lastposterid\', \'lastposter\'}">{vb:raw news.lastposter}</a>
			</div>
			<div>{vb:raw news.lastpostdate} <span class="time">{vb:raw news.lastposttime}</span></div>
		</vb:if>
		<vb:if condition="$mod_options[\'portal_archive_showreplies\'] OR $mod_options[\'portal_archive_showviews\']">
			<div style="padding-top:{vb:stylevar cellpadding}px">
				<vb:if condition="$mod_options[\'portal_archive_showreplies\']">{vb:raw news.replycount} {vb:rawphrase replies}</vb:if>{vb:raw archive_rep_view_comma}
				<vb:if condition="$mod_options[\'portal_archive_showviews\']">{vb:raw news.views} {vb:rawphrase views}</vb:if>
			</div>
		</vb:if>
	</div>
</div>',


'adv_portal_buddylistbits' =>
'<div style="padding-bottom:2px">
	<span style="float:{vb:stylevar right}">
	<a href="{vb:raw vboptions.bburl}/private.php?{vb:raw session.sessionurl}do=newpm&amp;u={vb:raw loggedin.userid}" title="{vb:rawphrase send_private_message_to_x, {vb:raw loggedin.username}}">{vb:rawphrase pm}</a>
	<a href="{vb:raw vboptions.bburl}/profile.php?{vb:raw session.sessionurl}do=removelist&amp;userlist=buddy&amp;u={vb:raw loggedin.userid}" title="{vb:rawphrase remove_from_buddy_list}">X</a>
	</span>
	<a href="{vb:raw vboptions.bburl}/{vb:link member, {vb:raw loggedin}}">{vb:raw loggedin.username}</a> {vb:raw loggedin.invisiblemark}
</div>',


'adv_portal_calendar_day' =>
'<td<vb:if condition="$show[\'highlighttoday\']"> class="today" title="{vb:rawphrase today}"</vb:if>>
	<vb:if condition="$show[\'daylink\']">
		<a href="{vb:raw vboptions.bburl}/calendar.php?{vb:raw session.sessionurl}do=getinfo&amp;day={vb:raw year}-{vb:raw month}-{vb:raw day}&amp;c={vb:raw calendarid}" title="{vb:raw eventdesc}">{vb:raw day}</a>
	<vb:else />
		<span class="simpleday">{vb:raw day}</span>
	</vb:if>
</td>',


'adv_portal_calendar_day_other' =>
'<td class="othermonth">{vb:raw day}</td>',


'adv_portal_calendar_header' =>
'<table class="calendar mini" width="100%" style="padding:0; margin:0">
<tr>
	<vb:if condition="$show[\'day1\']"><th class="blocksubhead">{vb:raw day1.short}</th></vb:if>
	<vb:if condition="$show[\'day2\']"><th class="blocksubhead">{vb:raw day2.short}</th></vb:if>
	<vb:if condition="$show[\'day3\']"><th class="blocksubhead">{vb:raw day3.short}</th></vb:if>
	<vb:if condition="$show[\'day4\']"><th class="blocksubhead">{vb:raw day4.short}</th></vb:if>
	<vb:if condition="$show[\'day5\']"><th class="blocksubhead">{vb:raw day5.short}</th></vb:if>
	<vb:if condition="$show[\'day6\']"><th class="blocksubhead">{vb:raw day6.short}</th></vb:if>
	<vb:if condition="$show[\'day7\']"><th class="blocksubhead">{vb:raw day7.short}</th></vb:if>
</tr>
{vb:raw calendarrowbits}
</table>',


'adv_portal_calendar_week' =>
'<tr>
	{vb:raw calendardaybits}
</tr>
',


'adv_portal_dragdrop_headinc' =>
'<script type="text/javascript" src="<vb:if condition="!$vboptions[\'remoteyui\']">{vb:raw vboptions.bburl}/</vb:if>{vb:stylevar yuipath}/yuiloader-dom-event/yuiloader-dom-event.js"></script>
<script type="text/javascript" src="<vb:if condition="!$vboptions[\'remoteyui\']">{vb:raw vboptions.bburl}/</vb:if>{vb:stylevar yuipath}/animation/animation-min.js"></script>
<script type="text/javascript" src="<vb:if condition="!$vboptions[\'remoteyui\']">{vb:raw vboptions.bburl}/</vb:if>{vb:stylevar yuipath}/dragdrop/dragdrop-min.js"></script>
<script type="text/javascript" src="{vb:raw vboptions.bburl}/clientscript/vba_cmps_dd.js"></script>
<style type="text/css">
<!--
ul.draglist {
	border: 1px dashed gray;
	margin: 10px 0 10px 0;
	min-width: 40px;
	padding: 15px 5px 15px 5px;
	list-style: none;
	position: relative;
}

ul.draglist li {
	margin: 2px;
	cursor: move;
}

-->
</style>',


'adv_portal_footer' =>
'<!-- Do NOT remove this copyright notice. Doing so is a violation of your user agreement! -->

<div align="center">{vb:rawphrase powered_by_vbadvanced_cmps, {vb:raw vba_options.portal_version}}</div>',


'adv_portal_moderation' =>
'<div class="blockrow">
	<vb:if condition="$show[\'threads\']">
		<div<vb:if condition="$moditems[\'thread\']"> style="font-weight: bold"</vb:if>><a href="{vb:raw vboptions.bburl}/moderation.php?{vb:raw session.sessionurl}do=viewthreads&amp;type=moderated">{vb:rawphrase threads}</a> ({vb:raw moditems.thread})</div>
	</vb:if>
	<vb:if condition="$show[\'posts\']">
		<div<vb:if condition="$moditems[\'reply\']"> style="font-weight: bold"</vb:if>><a href="{vb:raw vboptions.bburl}/moderation.php?{vb:raw session.sessionurl}do=viewposts&amp;type=moderated">{vb:rawphrase posts}</a> ({vb:raw moditems.reply})</div>
	</vb:if>

	<vb:if condition="$show[\'visitormessage\']">
		<div<vb:if condition="$moditems[\'visitormessage\']"> style="font-weight: bold"</vb:if>><a href="{vb:raw vboptions.bburl}/moderation.php?{vb:raw session.sessionurl}do=viewvms&amp;type=moderated">{vb:rawphrase visitor_messages}</a> ({vb:raw moditems.visitormessage})</div>
	</vb:if>

	<vb:if condition="$show[\'events\']">
		<div<vb:if condition="$events[\'count\']"> style="font-weight: bold"</vb:if>><a href="{vb:raw modcpdir}/moderate.php?{vb:raw session.sessionurl}do=events" target="_blank">{vb:rawphrase events}</a> ({vb:raw events.count})</div>
	</vb:if>
	<vb:if condition="$show[\'attachments\']">
		<div<vb:if condition="$attachments[\'count\']"> style="font-weight: bold"</vb:if>><a href="{vb:raw vboptions.bburl}/moderation.php?{vb:raw session.sessionurl}do=viewattachments">{vb:rawphrase attachments}</a> ({vb:raw attachments.count})</div>
	</vb:if>
	<div<vb:if condition="$users[\'count\']"> style="font-weight: bold"</vb:if>><a href="{vb:raw admincpdir}/user.php?{vb:raw session.sessionurl}do=moderate" target="_blank">{vb:rawphrase members}</a> ({vb:raw users.count})</div>

	{vb:raw template_hook.adv_portal_moderation}
</div>',


'adv_portal_module_wrapper' =>
'{vb:raw mods.formcode}

<div class="collapse" style="padding-bottom: {vb:raw vba_style.portal_vspace}px;">
	<h2 class="blockhead">
		<strong>{vb:raw vba_style.portal_blockbullet} <vb:if condition="$mods[\'link\']"><a href="{vb:raw mods.link}">{vb:raw mods.title}</a><vb:else />{vb:raw mods.title}</vb:if></strong>
		<vb:if condition="$vba_style[\'portal_collapsemods\']">
			<a class="collapse" id="collapse_module{vb:raw mods.collapse}" href="{vb:raw relpath}#top" style="top: 6px"><img src="{vb:stylevar imgdir_button}/collapse{vb:raw mods.collapseimg}.png" alt="" /></a>
		</vb:if>
	</h2>
	
	<div class="vba_module blockbody" id="module{vb:raw mods.collapse}"<vb:if condition="($mods[\'useshell\'] & $vba_shellint[\'collapse\'])"> style="display: none"</vb:if>>
		<vb:if condition="$show[\'table\']">
			<table align="center" border="0" cellpadding="0" cellspacing="0" class="blockbody" width="100%">
				{vb:raw modulehtml}
			</table>
		<vb:elseif condition="$mods[\'inctype\'] == \'bb_code\'" />
			<blockquote class="postcontent blockrow restore">
				<div class="bbcode_container" style="margin: 0;">
					{vb:raw modulehtml}
				</div>
			</blockquote>
		<vb:elseif condition="$show[\'divrow\']" />
			<div class="blockrow">
				{vb:raw modulehtml}
			</div>
		<vb:else />
			{vb:raw modulehtml}
		</vb:if>
	</div>
</div>
<vb:if condition="$show[\'endform\']"></form></vb:if>',


'adv_portal_navigation' =>
'<div class="blockrow">
	<vb:each from="navigationbits" value="page">
		<div>{vb:raw page.navmark} <vb:if condition="$page[\'link\']"><a href="{vb:raw page.link}">{vb:raw page.title}</a><vb:else />{vb:raw page.title}</vb:if></div>
	</vb:each>
	<vb:each from="customnavigationbits" value="page">
		<div>{vb:raw page.navmark} <vb:if condition="$page[\'link\']"><a href="{vb:raw page.link}">{vb:raw page.title}</a><vb:else />{vb:raw page.title}</vb:if></div>
	</vb:each>
</div>',


'adv_portal_navtab' =>
'<li<vb:if condition="$tabselected"> class="selected"</vb:if>><a href="{vb:raw vboptions.vba_portal_homeurl}<vb:if condition="$cmps_page[\'name\'] == \'home\'">{vb:raw session.sessionurl_q}<vb:else />?{vb:raw session.sessionurl}{vb:raw vboptions.vba_portal_pagevar}={vb:raw cmps_page.name}</vb:if>" class="navtab">{vb:raw cmps_page.title}</a></li>
<vb:if condition="$subpagelinks">
	<ul class="floatcontainer">
		{vb:raw subpagelinks}
	</ul>
</vb:if>',


'adv_portal_navtab_subpages' =>
'<li><a href="{vb:raw vboptions.vba_portal_homeurl}?{vb:raw vboptions.vba_portal_pagevar}={vb:raw cmps_subpage.name}">{vb:raw cmps_subpage.title}</a></li>',


'adv_portal_newsbits' =>
'<vb:if condition="!$mod_options[\'portal_news_legacy\']">
	<h2 class="blockrow">
		<vb:if condition="$mod_options[\'portal_news_showicon\']">{vb:raw vba_style.portal_blockbullet}</vb:if> {vb:raw news.prefix} <a href="{vb:raw vboptions.bburl}/{vb:link thread, {vb:raw news}}">{vb:raw news.title}</a>
	</h2>
</vb:if>
<div class="<vb:if condition="$mod_options[\'portal_news_legacy\']">blocksubhead<vb:else />blockrow</vb:if>">
	<div<vb:if condition="$mod_options[\'portal_news_showrating\'] AND $news[\'rating\']"> class="vba_rating{vb:raw news.rating}"</vb:if>>
		<vb:if condition="$news[\'subscribed\'] AND $mod_options[\'portal_news_showsubscribed\']">
			<img alt="" class="inlineimg" src="{vb:stylevar imgdir_misc}/subscribed.png" title="{vb:rawphrase you_are_subscribed_to_this_thread}" />
		</vb:if>
		{vb:raw news.dateposted} - {vb:rawphrase by_x, {vb:link member, {vb:raw news}, null, \'postuserid\', \'postusername\'}, {vb:raw news.postusername}}
	</div>
</div>
<div class="blockrow">
	<vb:if condition="$show[\'paperclip\']">
		<span style="float:{vb:stylevar right}">
			<a href="#" onclick="vba_attach_win({vb:raw news.threadid}); return false"><img class="inlineimg" src="{vb:stylevar imgdir_misc}/paperclip.png" border="0" title="{vb:rawphrase x_attachments, {vb:raw news.attach}}" alt="" /></a>
		</span>
	</vb:if>
	<table width="100%">
		<tr>
			<td valign="top">
				<vb:if condition="$news[\'avatarpath\']">
					<img align="{vb:stylevar left}" style="padding: 0 {vb:math {vb:stylevar padding}/2} {vb:math {vb:stylevar padding}/2} 0" alt="{vb:rawphrase xs_avatar, {vb:raw news.postusername}}" border="0" src="{vb:raw news.avatarpath}" />
				</vb:if>
				<blockquote class="postcontent restore">{vb:raw news.message}</blockquote>
			</td>
		</tr>
	</table>
		
	<vb:if condition="$show[\'signature\']">
		<div>__________________<br />{vb:raw news.signature}</div>
	</vb:if>
</div>
<vb:if condition="$news[\'attachment\']">
	<div class="attachments">
		<fieldset>
			<legend>{vb:rawphrase attached_files}</legend>
			<vb:each from="news[attachment]" value="attachment">
				<vb:if condition="$attachment[\'hasthumb\']">
					<a href="{vb:raw vboptions.bburl}/attachment.php?{vb:raw session.sessionurl}attachmentid={vb:raw attachment.attachmentid}&amp;d={vb:raw attachment.dateline}" rel="Lightbox{vb:raw attachment.lightboxid}" id="attachment{vb:raw attachment.attachmentid}"<vb:if condition="$show[\'newwindow\']"> target="_blank"</vb:if>><img src="{vb:raw vboptions.bburl}/attachment.php?{vb:raw session.sessionurl}attachmentid={vb:raw attachment.attachmentid}&amp;stc=1&amp;thumb=1&amp;d={vb:raw attachment.thumbnail_dateline}" class="thumbnail" border="0" alt="{vb:rawphrase image_larger_version_x_y_z, {vb:raw attachment.filename}, {vb:raw attachment.counter}, {vb:raw attachment.filesize}, {vb:raw attachment.attachmentid}}" /></a> &nbsp;
				<vb:else />
					<div>
						<img class="inlineimg" src="{vb:stylevar imgdir_attach}/{vb:raw attachment.attachmentextension}.gif" alt="{vb:rawphrase file_type_x, {vb:raw attachment.attachmentextension}}" width="16" height="16" border="0" style="vertical-align:baseline" /> <a href="{vb:raw vboptions.bburl}/attachment.php?{vb:raw session.sessionurl}attachmentid={vb:raw attachment.attachmentid}">{vb:raw attachment.filename}</a>
						({vb:raw attachment.filesize}, {vb:rawphrase x_views, {vb:raw attachment.counter}})
					</div>
				</vb:if>
			</vb:each>
		</fieldset>
	</div>
</vb:if>
<div class="postbit vba_news">
	<div class="postfoot" style="white-space: nowrap">
		<div class="textcontrols floatcontainer">
			<span class="postcontrols">
				<vb:if condition="$show[\'editbutton\']">
					<a class="editpost" href="{vb:raw vboptions.bburl}/editpost.php?{vb:raw session.sessionurl}do=editpost&amp;p={vb:raw news.postid}"><img src="{vb:stylevar imgdir_button}/trans_40b.png" id="editimg_{vb:raw news.postid}" alt="{vb:rawphrase edit_delete_message}" /> {vb:rawphrase edit_post}</a>
				</vb:if>
		
				<vb:if condition="$show[\'replybutton\']">
					<span class="seperator">&nbsp;</span>
					<a class="quickreply" href="{vb:raw vboptions.bburl}/newreply.php?{vb:raw session.sessionurl}do=newreply&amp;t={vb:raw news.threadid}" rel="nofollow"><img id="replyimg_{vb:raw news.postid}" src="{vb:stylevar imgdir_button}/trans_40b.png" alt="{vb:rawphrase quick_reply_to_this_message}" /> {vb:rawphrase reply}</a>
				</vb:if>

				<vb:if condition="$mod_options[\'portal_news_showsendfriend\']">
					<span class="seperator">&nbsp;</span>
					<a href="{vb:raw vboptions.bburl}/sendmessage.php?{vb:raw session.sessionurl}do=sendtofriend&amp;t={vb:raw news.threadid}" rel="nofollow" style="padding: 0"><img alt="" border="0" src="{vb:stylevar imgdir_siteicons}/email.png" title="{vb:rawphrase send_to_friend}" style="position: relative" /></a>
				</vb:if>
		
			</span>
			<span class="postlinking">
				<vb:if condition="$mod_options[\'portal_news_allowreplies\']">
					{vb:raw news.replycount} <vb:if condition="$news[\'reply_noformat\'] == 1">{vb:rawphrase reply}<vb:else />{vb:rawphrase replies}</vb:if>
				</vb:if>
				<vb:if condition="$mod_options[\'portal_news_showviews\'] AND $mod_options[\'portal_news_allowreplies\']"> | </vb:if>
				<vb:if condition="$mod_options[\'portal_news_showviews\']">
					{vb:raw news.views} {vb:rawphrase views}
				</vb:if>
			</span>
		</div>
	</div>
</div>
<br />
<br />',


'adv_portal_onlineusers' =>
'<div class="blocksubhead">{vb:rawphrase x_members_and_y_guests, {vb:raw numberregistered}, {vb:raw numberguest}}</div>
<div class="blockrow vba_spacer">
	<vb:if condition="$activeusers">
		<vb:each from="activeusers" value="loggedin">
	   		<a class="username" href="{vb:link member, {vb:raw loggedin}}">{vb:raw loggedin.musername}</a>{vb:raw loggedin.invisiblemark}{vb:raw loggedin.buddymark},
		</vb:each>
	<vb:else />
		{vb:rawphrase no_x_online, {vb:rawphrase members}}
	</vb:if>
</div>
<div class="blockrow">{vb:rawphrase most_users_ever_online_was_x_y_at_z, {vb:raw recordusers}, {vb:raw recorddate}, {vb:raw recordtime}}</div>',


'adv_portal_poll' =>
'<div class="blocksubhead">{vb:raw pollmod.question}</div>
<div class="vba_spacer">
	<vb:each from="pollbits" value="option">
		<vb:if condition="$pollmod[\'showresults\']">
			<div class="blockrow">
				<div>{vb:raw option.question}</div>
				<div class="pollbar{vb:raw option.graphicnumber}" style="width:{vb:math {vb:raw option.percent}*.6}%" title="{vb:raw option.votes} {vb:raw option.votephrase}"></div>
				<span>{vb:raw option.percent_formatted}%</span>	
			</div>
		<vb:elseif condition="$pollmod[\'multiple\']" />
			<div class="blockrow">
				<input id="pollchoice_{vb:raw mods.modid}_{vb:raw option.number}" name="optionnumber[{vb:raw option.number}]" type="checkbox" value="yes" />
				<label for="pollchoice_{vb:raw mods.modid}_{vb:raw option.number}">{vb:raw option.question}</label>
			</div>
		<vb:else />
			<div class="blockrow">
				<input id="pollchoice_{vb:raw mods.modid}_{vb:raw option.number}" name="optionnumber" type="radio" value="{vb:raw option.number}" />
				<label for="pollchoice_{vb:raw mods.modid}_{vb:raw option.number}">{vb:raw option.question}</label>
			</div>
		</vb:if>
	</vb:each>
</div>

<div class="blockrow vba_spacer">
		<vb:if condition="$pollmod[\'showresults\']">
			<strong>{vb:rawphrase total_votes}: {vb:raw pollmod.nvotes}</strong><br />{vb:raw pollmod.message}.
		<vb:else />
			<vb:if condition="$pollmod[\'public\'] AND $bbuserinfo[\'userid\']">
				<div>{vb:rawphrase public_poll_users_see_choices}</div>
			</vb:if>
			<input type="hidden" name="s" value="{vb:raw session.dbsessionhash}" />
			<input type="hidden" name="do" value="pollvote" />
			<input type="hidden" name="pollid" value="{vb:raw pollmod.pollid}" />
			<input type="submit" class="button" value="{vb:rawphrase vote_now}" />
		</vb:if>
</div>
<div class="blockrow">
	&raquo; <a href="{vb:raw vboptions.bburl}/poll.php?{vb:raw session.sessionurl}do=showresults&amp;pollid={vb:raw pollmod.pollid}">{vb:rawphrase view_poll_results}</a>
	<vb:if condition="$mod_options[\'portal_poll_allowreplies\']">
		<br />&raquo; <a href="{vb:raw vboptions.bburl}/newreply.php?{vb:raw session.sessionurl}t={vb:raw pollmod.threadid}">{vb:rawphrase comment_on_this_poll}</a>
		<br />&raquo; <a href="{vb:raw vboptions.bburl}/{vb:link thread, {vb:raw pollmod}, null, \'threadid\', \'threadtitle\'}">{vb:rawphrase this_poll_has} {vb:raw pollmod.replycount} <vb:if condition="$pollmod[\'replycount\'] == 1">{vb:rawphrase reply}<vb:else />{vb:rawphrase replies}</vb:if></a>
	</vb:if>
	<vb:if condition="$show[\'editpoll\']">
		<br />&raquo; <a href="{vb:raw vboptions.bburl}/poll.php?{vb:raw session.sessionurl}do=polledit&amp;pollid={vb:raw pollmod.pollid}">{vb:rawphrase edit_poll}</a>
	</vb:if>
</div>',


'adv_portal_recthreads_exp' =>
'<tr class="vba_module" style="border-right: 0; border-left: 0;">
	<vb:if condition="$mod_options[\'portal_threads_showicon\']">
		<td class="blockrow"><vb:if condition="$show[\'threadicon\']"><img alt="" border="0" src="{vb:raw thread.threadiconpath}" title="{vb:raw thread.threadicontitle}" /></vb:if></td>
	</vb:if>
	<td class="blockrow">
		<div<vb:if condition="$thread[\'rating\']"> class="vba_rating{vb:raw thread.rating}"</vb:if>>
			<vb:if condition="$mod_options[\'portal_threads_newpostarrow\'] AND $show[\'gotonewpost\']">
				<a href="{vb:raw vboptions.bburl}/{vb:link thread, {vb:raw thread}, {vb:raw pageinfo_newpost}}"><img alt="{vb:rawphrase go_to_first_new_post}" src="{vb:stylevar imgdir_button}/firstnew.png" border="0" class="inlineimg" /></a>
			</vb:if>
			{vb:raw thread.prefix}
			<a href="{vb:raw vboptions.bburl}/{vb:link thread, {vb:raw thread}}" title="{vb:raw thread.preview}"<vb:if condition="$show[\'gotonewpost\']"> style="font-weight: bold"</vb:if>>{vb:raw thread.title}</a>

			<vb:if condition="$mod_options[\'portal_threads_multipage\'] AND $show[\'pagenav\']">
				(<img class="inlineimg" src="{vb:stylevar imgdir_misc}/multipage.gif" border="0" alt="" /> {vb:raw thread.pagenav}<vb:if condition="$show[\'pagenavmore\']">... <a href="{vb:raw vboptions.bburl}/{vb:raw thread.lastpagelink}">{vb:rawphrase last_page}</a></vb:if>)
			</vb:if>
	
			<vb:if condition="$mod_options[\'portal_threads_threadstarter\']">
				<div>
					<vb:if condition="$thread[\'postuserid\']">
						<span style="cursor:pointer" onclick="window.open(\'{vb:raw vboptions.bburl}/{vb:link member, {vb:raw thread}, null, \'postuserid\', \'postusername\'}\')">{vb:raw thread.postusername}</span>
					<vb:else />
						{vb:raw thread.postusername}
					</vb:if>
				</div>
			</vb:if>
		</div>
		<vb:if condition="$thread[\'subscribed\'] OR $show[\'paperclip\'] OR ($thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\'])">
			<span style="float:{vb:stylevar right}">
				<vb:if condition="$thread[\'subscribed\']">
					<img alt="" class="inlineimg" src="{vb:stylevar imgdir_misc}/subscribed.png" title="{vb:rawphrase you_are_subscribed_to_this_thread}" />
				</vb:if>
				<vb:if condition="$show[\'paperclip\']">
					<a href="#" onclick="vba_attach_win({vb:raw thread.threadid}); return false"><img class="inlineimg" src="{vb:stylevar imgdir_misc}/paperclip.png" border="0" title="{vb:rawphrase x_attachments, {vb:raw thread.attach}}" alt="" /></a>
				</vb:if>
				<vb:if condition="$thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\']">
					<img class="inlineimg" src="{vb:stylevar imgdir_misc}/sticky.gif" title="{vb:rawphrase sticky_thread}" alt="" />
				</vb:if>
			</span>
		</vb:if>

		<vb:if condition="$mod_options[\'portal_threads_showdate\']">
			<div>{vb:raw thread.postdate} <span class="time">{vb:raw thread.posttime}</span></div>
		</vb:if>
	</td>
	<vb:if condition="$show[\'lastpost\']">
		<td class="blockrow">
			<div style="text-align:{vb:stylevar right}; white-space:nowrap">
				{vb:raw thread.lastpostdate} <span class="time">{vb:raw thread.lastposttime}</span><br />
				{vb:rawphrase by_x, {vb:link member, {vb:raw thread}, null, \'lastposterid\', \'lastposter\'}, {vb:raw thread.lastposter}} <a href="{vb:raw vboptions.bburl}/showthread.php?{vb:raw session.sessionurl}p={vb:raw thread.lastpostid}{vb:raw thread.highlight}<vb:if condition="$thread[\'pagenav\']">&amp;page={vb:raw thread.totalpages}</vb:if>#post{vb:raw thread.lastpostid}"><img alt="" border="0" src="{vb:stylevar imgdir_button}/lastpost-{vb:stylevar right}.png" title="{vb:rawphrase go_to_last_post}" /></a>
			</div>
		</td>
	</vb:if>
	<vb:if condition="$mod_options[\'portal_threads_replies\']">
		<td align="center" class="blockrow">{vb:raw thread.replycount}</td>
	</vb:if>
	<vb:if condition="$mod_options[\'portal_threads_views\']">
		<td align="center" class="blockrow">{vb:raw thread.views}</td>
	</vb:if>
	<vb:if condition="$mod_options[\'portal_threads_showforum\']">
		<td class="blockrow"><a href="{vb:raw vboptions.bburl}/{vb:link forum, {vb:raw thread}, null, \'forumid\', \'forumtitle\'}">{vb:raw thread.forumtitle}</a></td>
	</vb:if>
</tr>',


'adv_portal_recthreads_exp_head' =>
'<tr>
	<vb:if condition="$mod_options[\'portal_threads_showicon\']">
		<td class="blocksubhead" width="2%">&nbsp;</td>
	</vb:if>
	<td class="blocksubhead" width="50%"><vb:if condition="$mod_options[\'portal_threads_showrating\']"><span style="float:{vb:stylevar right}">{vb:rawphrase rating}</span></vb:if>{vb:rawphrase title_username_date}</td>
	<vb:if condition="$mod_options[\'portal_threads_lastpost\']">
		<td align="center" class="blocksubhead" style="white-space: nowrap" width="25%">{vb:rawphrase last_post}</td>
	</vb:if>
	<vb:if condition="$mod_options[\'portal_threads_replies\']">
		<td class="blocksubhead" width="2%">{vb:rawphrase replies}</td>
	</vb:if>
	<vb:if condition="$mod_options[\'portal_threads_views\']">
		<td class="blocksubhead" width="2%">{vb:rawphrase views}</td>
	</vb:if>
	<vb:if condition="$mod_options[\'portal_threads_showforum\']">
		<td align="center" class="blocksubhead" width="20%">{vb:rawphrase forum}</td>
	</vb:if>
</tr>',


'adv_portal_recthreads_lean' =>
'<div class="blockrow vba_spacer">
	<vb:if condition="$show[\'paperclip\'] OR ($thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\'])">
		<span style="float:{vb:stylevar right}">
			<vb:if condition="$show[\'paperclip\']">
				<a href="#" onclick="vba_attach_win({vb:raw thread.threadid}); return false"><img class="inlineimg" src="{vb:stylevar imgdir_misc}/paperclip.png" border="0" title="{vb:rawphrase x_attachments, {vb:raw thread.attach}}" alt="" /></a>
			</vb:if>
			<vb:if condition="$thread[\'sticky\'] AND $mod_options[\'portal_threads_stickyicon\']">
				<img class="inlineimg" src="{vb:stylevar imgdir_misc}/sticky.gif" title="{vb:rawphrase sticky_thread}" alt="" />
			</vb:if>
		</span>
	</vb:if>

	<vb:if condition="$show[\'threadicon\']">
		<img class="inlineimg" src="{vb:raw thread.threadiconpath}" title="{vb:raw thread.threadicontitle}" border="0" alt="" />
	</vb:if>
	<vb:if condition="$thread[\'subscribed\']">
		<img alt="" class="inlineimg" src="{vb:stylevar imgdir_misc}/subscribed.png" title="{vb:rawphrase you_are_subscribed_to_this_thread}" />
	</vb:if>
	<vb:if condition="$mod_options[\'portal_threads_newpostarrow\'] AND $show[\'gotonewpost\']">
		<a href="{vb:raw vboptions.bburl}/{vb:link thread, {vb:raw thread}, {vb:raw pageinfo_newpost}}"><img alt="{vb:rawphrase go_to_first_new_post}" src="{vb:stylevar imgdir_button}/firstnew.png" border="0" class="inlineimg" /></a>
	</vb:if>
	{vb:raw thread.prefix} <a href="{vb:raw vboptions.bburl}/{vb:link thread, {vb:raw thread}}" title="<vb:if condition="$thread[\'preview\']">{vb:raw thread.preview}</vb:if>"<vb:if condition="$show[\'gotonewpost\']"> style="font-weight: bold"</vb:if>>{vb:raw thread.title}</a>
	<vb:if condition="$mod_options[\'portal_threads_multipage\'] AND $show[\'pagenav\']">
		(<img class="inlineimg" src="{vb:stylevar imgdir_misc}/multipage.gif" border="0" alt="" /> {vb:raw thread.pagenav}<vb:if condition="$show[\'pagenavmore\']">... <a href="{vb:raw thread.lastpagelink}">{vb:rawphrase last_page}</a></vb:if>)
	</vb:if>
	<vb:if condition="$mod_options[\'portal_threads_showdate\']">
		<div>{vb:raw thread.postdate} <span class="time">{vb:raw thread.posttime}</span></div>
	</vb:if>
	<div>
		<vb:if condition="$thread[\'rating\']">
			<img src="{vb:stylevar imgdir_rating}/rating-trans-15_{vb:raw thread.rating}.png" alt="" />
		</vb:if>
		<vb:if condition="$mod_options[\'portal_threads_threadstarter\']">
			<div>
				<vb:if condition="$thread[\'postuserid\']">
					{vb:rawphrase by_x, {vb:link member, {vb:raw thread}, null, \'postuserid\', \'postusername\'}, {vb:raw thread.postusername}}
				<vb:else />
					{vb:rawphrase by} {vb:raw thread.postusername}
				</vb:if>
			</div>
		</vb:if>
	
		<vb:if condition="$mod_options[\'portal_threads_showforum\']">
			<div style="padding-top: 4px"><a href="{vb:raw vboptions.bburl}/{vb:link forum, {vb:raw thread}, null, \'forumid\', \'forumtitle\'}">{vb:raw thread.forumtitle}</a></div>
		</vb:if>
		<vb:if condition="$show[\'lastpost\']">
			<div style="padding-top: 4px"><a href="{vb:raw vboptions.bburl}/showthread.php?{vb:raw session.sessionurl}p={vb:raw thread.lastpostid}{vb:raw thread.highlight}<vb:if condition="$thread[\'pagenav\']">&amp;page={vb:raw thread.totalpages}</vb:if>#post{vb:raw thread.lastpostid}"><img alt="" border="0" src="{vb:stylevar imgdir_button}/lastpost-{vb:stylevar right}.png" title="{vb:rawphrase go_to_last_post}" /></a> {vb:rawphrase last_post_by} <a href="{vb:raw vboptions.bburl}/{vb:link member, {vb:raw thread}, null, \'lastposterid\', \'lastposter\'}">{vb:raw thread.lastposter}</a></div>
			<div>{vb:raw thread.lastpostdate} <span class="time">{vb:raw thread.lastposttime}</span></div>
		</vb:if>
		<vb:if condition="$mod_options[\'portal_threads_replies\'] OR $mod_options[\'portal_threads_views\']">
			<div style="padding-top: 4px"><vb:if condition="$mod_options[\'portal_threads_replies\']">{vb:raw thread.replycount} {vb:rawphrase replies}</vb:if>{vb:raw recthreads_comma} <vb:if condition="$mod_options[\'portal_threads_views\']">{vb:raw thread.views} {vb:rawphrase views}</vb:if></div>
		</vb:if>
	</div>
</div>',


'adv_portal_search' =>
'<div class="blockrow">
	<input class="textbox" name="query" size="13" type="text" /> <input type="submit" class="button" value="{vb:rawphrase go}" />
</div>
<div class="blockrow">
	&raquo; <a href="{vb:raw vboptions.bburl}/search.php{vb:raw session.sessionurl_q}">{vb:rawphrase advanced_search}</a>
</div>',


'adv_portal_stats' =>
'<div class="blockrow">
	<vb:if condition="$mod_options[\'portal_stats_members\']">{vb:rawphrase members}: {vb:raw numbermembers}<br /></vb:if>
	<vb:if condition="$mod_options[\'portal_stats_threads\']">{vb:rawphrase threads}: {vb:raw totalthreads}<br /></vb:if>
	<vb:if condition="$mod_options[\'portal_stats_posts\']">{vb:rawphrase posts}: {vb:raw totalposts}<br /></vb:if>
	<vb:if condition="$mod_options[\'portal_stats_topposter\']">{vb:rawphrase top_poster}: <a href="{vb:link member, {vb:raw topposter}}">{vb:raw topposter.username}</a> ({vb:raw topposter.posts})<br /></vb:if>
	{vb:raw template_hook.adv_portal_stats}
</div>
<vb:if condition="$mod_options[\'portal_stats_newestmember\']">
	<div class="blockrow">
		{vb:rawphrase welcome_to_our_newest_member_x, {vb:link member, {vb:raw newuser}}, {vb:raw newuser.username}}
	</div>
</vb:if>',


'adv_portal_welcomeblock_expanded' =>
'<div class="blockrow">
	<vb:if condition="$show[\'guest\']">
		<table width="100%" cellspacing="0" cellpadding="{vb:stylevar padding}">
			<tr>
				<td style="white-space: nowrap">{vb:rawphrase user_name}</td>
				<td><input class="textbox" name="vb_login_username" size="12" type="text" tabindex="577" /></td>
				<td style="white-space: nowrap"><input checked="checked" name="cookieuser" id="cb_cookieuser" type="checkbox" value="1" /><label for="cb_cookieuser">{vb:rawphrase remember_me}</label></td>
				<td align="center" rowspan="2" width="100%">{vb:rawphrase not_a_member_yet_register_now, {vb:raw vboptions.bburl}}</td>
			</tr>
			<tr>
				<td>{vb:rawphrase password}</td>
				<td><input class="textbox" name="vb_login_password" size="12" type="password" tabindex="578" /></td>
				<td><input class="button" type="submit" value="{vb:rawphrase log_in}" tabindex="579" /></td>
			</tr>
		</table>
	<vb:else />
		<table width="100%" cellpadding="0" cellspacing="0">
			<tr>
				<vb:if condition="$avatarurl">
					<td valign="top" align="left" style="padding-{vb:stylevar right}: {vb:stylevar padding}" >
						<a href="{vb:raw vboptions.bburl}/profile.php?{vb:raw session.sessionurl}do=editavatar"><img src="{vb:raw avatarurl}" border="0" alt="{vb:rawphrase edit_avatar}" align="{vb:stylevar left}" /></a>
					</td>
				</vb:if>
				<td valign="top" width="100%">
					<vb:if condition="$bbuserinfo[\'reputationdisplay\'] OR ($bbuserinfo[\'rank\'] AND $mod_options[\'portal_welcome_rank\'])">
						<div style="float:{vb:stylevar right}">
						<vb:if condition="$bbuserinfo[\'reputationdisplay\']">
							{vb:rawphrase rep_power}: {vb:raw reppower}
							<div align="{vb:stylevar right}" style="padding-bottom:{vb:stylevar cellpadding}px">{vb:raw bbuserinfo.reputationdisplay}</div>
						</vb:if>
						<vb:if condition="$bbuserinfo[\'rank\'] AND $mod_options[\'portal_welcome_rank\']">
							<div align="{vb:stylevar right}" style="padding-top:{vb:stylevar cellpadding}px; padding-bottom:{vb:stylevar cellpadding}px">{vb:raw bbuserinfo.rank}</div>
						</vb:if>
						</div>
					</vb:if>
			
					{vb:rawphrase welcome_back_x, {vb:raw bbuserinfo.username}}<br />
					{vb:rawphrase last_visited_x_at_y, {vb:raw lastvisitdate}, {vb:raw lastvisittime}}<br />
					<vb:if condition="$mod_options[\'portal_welcome_newposts\']">
						<a href="{vb:raw vboptions.bburl}/search.php?{vb:raw session.sessionurl}do=getnew">{vb:rawphrase vba_new_posts}</a>: {vb:raw newposts}<br />
					</vb:if>
			
					<a href="{vb:raw vboptions.bburl}/login.php?{vb:raw session.sessionurl}do=logout&amp;logouthash={vb:raw bbuserinfo.logouthash}" onclick="return log_out(\'{vb:rawphrase sure_you_want_to_log_out}\')">{vb:rawphrase log_out}</a>
				</td>
			</tr>
		</table>
	</div>
		<vb:if condition="$mod_options[\'portal_welcome_newpms\'] AND $show[\'pmstats\']">
			<h3 class="blocksubhead">
				<a href="{vb:raw vboptions.bburl}/private.php{vb:raw session.sessionurl_q}">{vb:rawphrase private_messages}</a>
			</h3>
			<div class="blockrow">{vb:rawphrase x_new_have_y_of_z_allowed, {vb:raw bbuserinfo.pmunread}, {vb:raw bbuserinfo.pmtotal}, {vb:raw permissions.pmquota}}
		</vb:if>
	</vb:if>
</div>',


'adv_portal_welcomeblock_lean' =>
'<div class="blockrow">
	<vb:if condition="$bbuserinfo[\'userid\']">
		<div>{vb:rawphrase welcome_back_x, {vb:raw bbuserinfo.username}}</div>

		<vb:if condition="$avatarurl">
			<div style="padding:{vb:math {vb:stylevar padding}/2} 0 {vb:math {vb:stylevar padding}/2} 0">
				<a href="{vb:raw vboptions.bburl}/profile.php?{vb:raw session.sessionurl}do=editavatar"><img src="{vb:raw avatarurl}" border="0" alt="{vb:rawphrase edit_avatar}" /></a>
			</div>
		</vb:if>

		<div>{vb:rawphrase last_visited_x_at_y, {vb:raw lastvisitdate}, {vb:raw lastvisittime}}</div>
		<vb:if condition="$mod_options[\'portal_welcome_newposts\']">
			<div style="padding-top: {vb:math {vb:stylevar padding}/2}"><a href="{vb:raw vboptions.bburl}/search.php?{vb:raw session.sessionurl}do=getnew">{vb:rawphrase vba_new_posts}</a>: {vb:raw newposts}</div>
		</vb:if>
		<vb:if condition="$bbuserinfo[\'reputationdisplay\']">
			<div style="padding-top: {vb:math {vb:stylevar padding}/2}">
				{vb:rawphrase rep_power}: {vb:raw reppower}<br />
				{vb:raw bbuserinfo.reputationdisplay}
			</div>
		</vb:if>
		<vb:if condition="$bbuserinfo[\'rank\'] AND $mod_options[\'portal_welcome_rank\']">
			<div style="padding-top: {vb:math {vb:stylevar padding}/2}">{vb:raw bbuserinfo.rank}</div>
		</vb:if>
		<div style="padding-top: {vb:math {vb:stylevar padding}/2}">
			<a href="{vb:raw vboptions.bburl}/login.php?{vb:raw session.sessionurl}do=logout&amp;logouthash={vb:raw bbuserinfo.logouthash}" onclick="return log_out(\'{vb:rawphrase sure_you_want_to_log_out}\')">{vb:rawphrase log_out}</a>
		</div>

		<vb:if condition="$mod_options[\'portal_welcome_newpms\'] AND $show[\'pmstats\']">
	</div>
	<div class="blocksubhead">
		<a href="{vb:raw vboptions.bburl}/private.php{vb:raw session.sessionurl_q}">{vb:rawphrase private_messages}</a>
	</div>
	<div class="blockrow">
		{vb:rawphrase x_new_have_y_of_z_allowed, {vb:raw bbuserinfo.pmunread}, {vb:raw bbuserinfo.pmtotal}, {vb:raw permissions.pmquota}}

	</vb:if>

	<vb:else />
		{vb:rawphrase user_name}:<br />
		<input class="textbox" name="vb_login_username" size="12" type="text" tabindex="577" /><br />
		{vb:rawphrase password}:<br />
		<input class="textbox" name="vb_login_password" size="12" type="password" tabindex="578" /><br />
		<input name="cookieuser" id="cb_cookieuser" type="checkbox" value="1" /><label for="cb_cookieuser">{vb:rawphrase remember_me}</label>

		<div style="padding-top:{vb:stylevar padding}; padding-bottom:{vb:stylevar padding};">
			<input class="button" type="submit" value="{vb:rawphrase log_in}" tabindex="579" />
		</div>

		{vb:rawphrase not_a_member_yet_register_now, {vb:raw vboptions.bburl}}
	</vb:if>
</div>');



// ##### Phrases ##############################################################
$mainphrases['adv_portal'] = array(
	'active_users' => 'Active Users',
	'buddies' => 'buddies',
	'by' => 'By',
	'comment_on_this_poll' => 'Comment On This Poll',
	'customize_this_page' => 'Customize This Page',
	'edit_this_post' => 'Edit This Post',
	'exit_customization_mode' => 'Exit Customization Mode',
	'last_post_by' => 'Last post by',
	'last_visited_x_at_y' => 'You last visited: {1} at {2}',
	'latest_forum_topics' => 'Latest Forum Topics',
	'new_pms' => 'New PMs',
	'no_x_online' => 'No {1} online',
	'no_x_to_display' => 'No {1} to Display.',
	'not_a_member_yet_register_now' => 'Not a member yet?<br />
<a href="{1}/register.php">Register Now!</a>',
	'online_buddies' => 'Online Buddies',
	'pm' => 'PM',
	'poll_results' => 'Poll Results',
	'powered_by_vbadvanced_cmps' => 'Powered by <a href="http://www.vbadvanced.com/" target="_blank">vBadvanced</a> CMPS v{1}',
	'rating' => 'Rating',
	'read_more' => ' [<a href="{1}/showthread.php?{3}t={2}">Read More</a>]',
	'remove_from_buddy_list' => 'Remove from buddy list',
	'rep_power' => 'Rep Power',
	'reply_to_this_post' => 'Reply to This Post',
	'reset_layout' => 'Reset Layout',
	'send_to_friend' => 'Send to Friend',
	'sorry_only_vb_37' => 'Sorry, but this module will not work with vBulletin versions prior to v3.7.',
	'this_poll_has' => 'This Poll Has',
	'title_username_date' => 'Title, Username, &amp; Date',
	'top_poster' => 'Top Poster',
	'total_votes' => 'Total Votes',
	'vba_new_posts' => 'New Posts',
	'vote' => 'Vote',
	'welcome_back_x' => 'Welcome back <strong>{1}</strong>',
	'x_new_have_y_of_z_allowed' => '{1} New PMs. You have {2} total out of {3} allowed.'
);

$mainphrases['adv_portal_cp'] = array(
	'active' => 'Active',
	'active_set_to_no_disable' => 'Active

<div>Setting this option to \'No\' will prevent this module from being shown on any pages.</div>',
	'active_modules' => 'Active Modules',
	'add_child_page' => 'Add Child Page',
	'add_module' => 'Add Module',
	'add_more' => 'Add More',
	'add_navbar_link' => 'Add Navbar Link',
	'add_navbar_link_desc' => 'If you would like to add a link to this page to your navbar, select the position of the link here.',
	'add_page' => 'Add Page',
	'add_remove_from_pages' => 'Add/Remove From Pages',
	'add_remove_modules_from_pages' => 'Add/Remove Modules From Pages',
	'add_setting' => 'Add Setting',
	'advanced_options' => 'Advanced Options',
	'advanced_options_description' => 'Here you may specify a different value for any default settings that will apply only to this page. Click the + image next to a group or module\'s title to expand the settings for that group. If you have previously customized a setting and wish to revert this page back to using the default value, check the &quot;Use Default&quot; checkbox to the right of that setting\'s title and then save this page.',
	'allow_html' => 'Allow HTML',
	'allow_image_code' => 'Allow [IMG] code',
	'allow_page_customization' => 'Allow Page Customization<div>When this setting is enabled, your members will see a \'Customize This Page\' link that will allow them to re-arrange the active modules on this page and set a custom layout visible only to them.',
	'allow_smilies' => 'Allow Smilies',
	'also_delete_module_file_x' => 'Also delete the file &quot;modules/{1}&quot;',
	'also_delete_template_x' => 'Also delete the template called &quot;adv_portal_{1}&quot;',
	'alternative_module_wrapper_template' => 'Alternative Module Wrapper Template<div>If you would like, you may specify a different template to wrap around the contents of this module by entering its title here. If left blank, this module will use the \'adv_portal_module_wrapper\' template instead if the setting above is enabled.</div>',
	'are_you_sure_delete_module_called_x' => 'Are you sure you want to delete the module called <strong>{1}</strong>?<br />
This action can <strong>NOT</strong> be undone.',
	'are_you_sure_delete_page_called_x' => 'Are you sure you want to delete the page called <strong>{1}</strong>?<br />
This action can <strong>NOT</strong> be undone.',
	'bb_code' => 'BB Code',
	'bbcode_allows_bbcode' => 'BB Code {1}s allow you to use the vBulletin text editor to format your {2} using BB code. BB Code {1}s are recommended for simpler {2}s containing text, images, or anything else that can be done using BB code. Allowing HTML code is optional, but a Template {1} is recommended for anything more than light HTML formatting.',
	'center_column' => 'Center Column',
	'change_x_type' => 'Change {1} Type',
	'change_x_type_note' => 'You are about to change this {1} from a {2} {1} to a {3} {1}. Please note that once you hit the \'Save\' button below any previous information that was stored in the \'{2} {1} Type Options\' will be lost. However, you may change the type of this {1} back at any time.',
	'change_x_type_to' => 'Change {1} Type To',
	'choose_a_file' => 'Choose a File',
	'clean_file_output' => 'Clean File Output
<div>If your are trying to include a PHP file that was not written specifically for vBulletin or vBadvanced, it may be necessary to &quot;clean&quot; the output of this file. If you add a module and the content prints out as the first thing on the top your page, this is a good indication that it needs to be cleaned.</div>',
	'cmps_page_to_integrate_with' => 'CMPS Page to Integrate With',
	'cmps_page_to_integrate_with_desc' => 'Select the default CMPS page that you would like to use to integrate with and &quot;wrap around&quot; your files.<br /> You will also be able to change the page used with each file in the next step, but selecting a page here may save you time as each file will have this page pre-selected.<div style="padding-top: 4px">Note: Only CMPS &quot;Module&quot; pages with the &quot;Custom Page Content&quot; module enabled may be selected here. Other pages will be visible, but disabled.</div>',
	'cmps_product_inactive' => 'vBadvanced CMPS is disabled in your vBulletin <a href="plugin.php?do=product">Installed Products</a> section. Please enable vBadvanced CMPS in order for it to work.',
	'collapse_module_by_default' => 'Collapse Module by Default<div>Turn this option on if you would like this module to appear collapsed and require your users to click the &quot;expand&quot; image before revealing the content of the module. Note that your &quot;Enable Collapsible Modules&quot; setting must be enabled for this to work.',
	'content' => 'Content',
	'copy' => 'Copy',
	'copy_page' => 'Copy Page',
	'copy_module' => 'Copy Module',
	'copy_module_layout' => 'Copy Module Layout',
	'copy_module_layout_from_another_page' => 'Copy Module Layout From Another Page',
	'copying_x_note' => 'You have selected to copy your {1} titled &quot;{2}&quot;. Change any of the options below as you would like and then hit the &quot;Save&quot; button to add the new {1}.',
	'css_templates_to_include_x' => 'CSS Templates to Include<div class="smallfont">Here you may enter any CSS template names that this {1} requires. Separate each template with a carriage return (new line).</div>',
	'current_integrated_pages' => 'Current Integrated Pages',
	'current_selected_threads' => 'Current Selected Threads',
	'currently_running_latest_available' => 'You are currently running vBadvanced CMPS v{1}.<br />
<br />
The latest version available is {2}.<br />

<br />
{3}',
	'custom_content_title' => 'Custom Content Title
<div>This is what will be placed in the header row of your wrapper template.',
	'custom_page_content_description' => 'This module is used to display the various types of content from your pages. For example, if you add a Template Page, the content of the template specified on that page will be output within this module.',
	'custom_page_content_desc' => 'Custom Page Content<div>This is where the content from the {1} above will be displayed.</div>',
	'custom_page_content_integrate_desc' => 'Custom Page Content<div>If this page is used for integration, the content from the integrated file will be displayed here. Otherwise this module should be left inactive.</div>',

	'custom_style_for_this_page' => 'Custom Style for this Page',
	'custom_style_for_this_page_desc' => 'If you would like, you may select a style to use for this page. If a style is selected, that style will override your default vBulletin or any user chosen style settings on this page.',
	'date_created' => 'Date Created',
	'delete_page_integrated_files' => 'The following files/THIS_SCRIPT constants have been integrated with this page. Please choose to either remove the integration or integrate these with a different CMPS page below.',
	'display_child_pages_in_submenu' => 'Display Child Pages In Sub-Menu<div class="smallfont">Turn this setting on if you would like to display this pages child pages in the navbar sub-menu when this pages tab is selected. Note this only works if the \'Add Navbar Link\' setting above is enabled.</div>',
	'display_order_page_desc' => 'This controls the order that the page will be displayed in for the Site Navigation module and in the Admin CP.',
	'dot_xml' => '.xml',
	'dot_module_serialized_data' => '.module (serialized data)',
	'download_file_type' => 'Download File Type',
	'download_module' => 'Download Module',
	'duplicate_filename' => 'Duplicate Filename',
	'duplicate_filename_desc' => '<div>You already have a file called <strong>{1}</strong> in your modules folder. Please choose a different name for the file.',
	'duplicate_module_identifier' => 'Duplicate Module Identifier
',
	'duplicate_module_identifier_desc' => '<div>You already have a module with an identifier of \'{1}\'. Please select a different identifier.</div>',
	'dynamic' => 'Dynamic',
	'edit_module' => 'Edit Module',
	'edit_modules' => 'Edit Modules',
	'edit_page' => 'Edit Page',
	'edit_pages' => 'Edit Pages',
	'edit_setting' => 'Edit Setting',
	'edit_settings' => 'Edit Settings',
	'edit_template' => 'Edit Template',
	'edit_template_for_x_in_style' => 'Edit the template for this {1} in the following style: ',
	'edit_threads' => 'Edit Threads',
	'end' => 'End',
	'expanded' => 'Expanded',
	'file_allows_file' => 'PHP File {1}s will allow you to specify a file {3} that will be displayed as the content for the {2}. ',
	'file_to_include' => 'File to Include',
	'form_code' => 'Form Code
<div>If your module requires a &lt;form&gt; tag, you may enter the code for that form tag here. This allows for the code to be placed above the table and comply with XHTML standards.',
	'from_anywhere_on_your_server' => 'from anywhere on your server',
	'from_modules_directory' => 'from the <i>{vbulletin}</i>/modules/ directory on your server ',
	'here_specify_which_usergroups_access_page' => 'Here you may specify which usergroups will have access to this page.',
	'here_specify_which_usergroups_view_module' => 'Here you may specify which usergroups will be able to view this module.',
	'hide_page_in_site_navigation' => 'Hide this page in these modules:',
	'html_allows_html' => 'An HTML Page will allow you to specify a HTML file on your server to include which will be displayed as the content for this page.',
	'html_file' => 'HTML File',
	'identifier' => 'Identifier',
	'identifier_desc' => 'PHP file modules require a unique identifier to help identify the module and its settings. Please note that this cannot be changed later and the identifier used for each PHP module must be unique.',
	'choose_a_page_to_copy_layout_from' => 'If you would like, you may choose to copy the module layout from one of your previously created pages. Note that this will override any custom layout changes set below.',
	'inactive' => 'Inactive',
	'inactive_modules' => 'Inactive Modules',
	'initialize_bbcode_parser' => 'Initialize BB Code Parser<div>If this module uses vBulletin BB codes in any way, this option must be turned on.</div>',
	'initialize_forum_permissions' => 'Initialize Forum Permissions<div>If this module pulls information regarding your forums, threads, or posts, and you wish to apply your vBulletin forum permissions to this module, this option must be turned on.</div>',
	'initialize_ignored_users' => 'Initialize Ignored Users<div>If this module pulls information regarding your forum\'s threads, or posts, and you wish to prevent threads/posts from users on a member\'s ignore list or users listed in your &quot;Tachy Goes to Coventry&quot; vBulletin setting from being displayed, this option must be turned on.',
	'initialize_moderator_cache' => 'Initialize Moderator Cache/Permissions<div>If this module requires information for your moderator permissions (ie: uses the can_moderate() function), this option must be turned on to initialize your moderator permissions.',
	'integate_new_pages' => 'Integrate New Pages',
	'integration' => 'Integration',
	'integration_allows_you_include_cmps' => 'This tool will allow you to easily integrate your other vBulletin pages and hacks, thus &quot;wrapping&quot; a specified CMPS page around the content of your vBulletin page. Fill out the form below to get started.<div style="padding-top:4px"><strong>Note:</strong> Only CMPS &quot;Module&quot; Pages with the &quot;Custom Page Content&quot; module enabled may be used for integration. This is necessary as the &quot;Custom Page Content&quot; module is where the output from this page will be printed.</div>',
	'last_updated' => 'Last Updated',
	'last_vote' => 'Last Vote',
	'lean' => 'Lean',
	'left_column' => 'Left Column',
	'level' => 'Level',
	'link' => 'Link',
	'main_options' => 'Main Options',
	'meta_description' => 'Meta Description
<div>Here you may enter a meta description for this page. Leave this setting blank to use your default vBulletin setting.</div>',
	'meta_keywords' => 'Meta Keywords
<div>Here you may enter a list of meta keywords for this page. Leave this setting blank to use your default vBulletin setting.</div>',
	'middle' => 'Middle',
	'module' => 'Module',
	'module_allows_module' => 'A Module Page will allow you to select any of your modules which you would like to display on this page. Module pages may also be used to integrate other vBulletin pages and hacks using the \'Integration\' link in the left frame.',
	'module_cache' => 'Module Cache',
	'module_dragdrop_desc' => 'To arrange the modules on this page, click on the module title and drag it to the location you would like it to appear. To remove a module from this page, drag it to the Inactive Modules box to the left.<br /><br /><strong>Don\'t forget to save the page after making any changes!</strong>',
	'module_parent' => 'Module Parent
<div>With some select modules (such as the News Archive) it may be necessary to specify a parent module. If this module requires a parent module you may specify that parent here.</div>',
	'module_wrapper_template_options' => 'Module Wrapper Template Options',
	'module_title' => 'Module Title',
	'module_type' => 'Module Type',
	'modules' => 'Modules',
	'move_to' => 'Move to',
	'newer_version_available' => '<strong>There is a newer version of vBadvanced CMPS available!</strong><br />
<br />
Please check <a href="http://www.vbadvanced.com/" target="_blank">vBadvanced.com</a> for more info.
',
	'no_modules' => 'No Modules',
	'no_x_to_display' => 'No {1} to Display.',
	'note_integrates_any_file_with_same_name' => 'Note that this will integrate <strong>any</strong> files with the name(s) that use vBulletin as a back-end. If you have other programs or hacks that use vBulletin as a back-end and they use any of the filenames listed here, those files will be integrated as well. To avoid this, use the &quot;THIS_SCRIPT Integration Method&quot; option below for these files instead.',
	'option_code' => 'Option Code',
	'options_apply_to_module_wrapper' => 'This section deals with options that may be applied to your \'adv_portal_module_wrapper\' template. Please note that the options are only applicable if the \'Use Module Wrapper Template\' option below is set to \'Yes\'.',
	'order' => 'Order',
	'other_filenames_to_integrate' => 'Other Filenames to Integrate',
	'other_filenames_to_integrate_desc' => 'If you would like to integrate other file names that may not be listed above, simply enter the name of the file(s) here. Separate each file name with a carriage return (new line).',
	'overwrite_file_with_new_file' => 'Overwrite File With New File',
	'overwrite_templates' => 'Overwrite Templates
',
	'overwrite_templates_desc' => '<div>The following template(s) already exist in this style:</div>
<div style="padding-top:5px; padding-bottom:5px">{1}</div>
<div>Select \'yes\' to overwrite your current templates with the new ones, or select no to keep your current templates.</div>',
	'page_active' => 'Page Active
<div>When set to \'No\', this page will only be visible to moderators and admins.</div>',
	'pages_active_on' => 'Pages Active On',
	'page_contains_following_sub_pages' => 'This page currently has the following sub-pages. If you do not wish to remove any of these pages as well, you must select a new parent page for any of the pages listed below.',
	'page_identifier' => 'Page Identifier',
	'page_identifier_example' => 'This is the variable that will be used in the URL to link to this page. For example, if this option is set to \'games\', then the link to this page would look like this: {1}?{2}=games</div>',
	'page_parentlists' => 'Page Parentlists',
	'page_title' => 'Page Title',
	'page_to_copy_from' => 'Page to Copy From',
	'page_type' => 'Page Type',
	'pages_to_copy_to' => 'Page(s) to Copy To',
	'parent_page' => 'Parent Page',
	'parent_page_desc' => 'Selecting a &quot;Parent Page&quot; here will display that page (and any parent pages of the page selected) in the navbits and other places, giving the appearance that this page is a sub-page of the page selected here.',
	'path_to_file' => 'Path to File
<div>Here you may specify the path to a file to include which will replace the content of your \'Custom Page Content\' module.</div>',
	'php_file' => 'PHP File',
	'please_select_a_page' => 'Please Select a Page',
	'please_select_type_of_x_to_add' => 'Please select which type of {1} you would like to add.',
	'plugins_inactive_x' => 'The following default plugins are inactive. Please enable them via the <a href="plugin.php?do=modify">Plugin Manager</a>.<br />{1}',
	'plugins_missing' => 'One or more of your vBadvanced CMPS plugins are missing. Please use the \'Reinstall the vBulletin plugins\' option from the \'Maintenance\' section of the admincp/vbacmps_install.php file to re-install the plugins.',
	'random' => 'Random',
	'rating' => 'Rating',
	'rebuild_x' => 'Rebuild {1}',
	'remove_module' => 'Remove Module',
	'rename_to_filename_entered_below' => 'Rename to Filename Entered Below',
	'right_column' => 'Right Column',
	'select_an_action' => 'Select an action',
	'select_module_upload' => 'Module to Upload<div>Please select a .module or .xml file from your computer to upload.</div>',
	'select_new_parent' => 'Select New Parent',
	'select_new_threads' => 'Select New Threads',
	'select_pages_to_integrate_and_save' => 'Select the CMPS page that you would like to integrate with each file or THIS_SCRIPT constant below. Once you have made your selections, click &quot;Save&quot; to finalize the integration.',
	'select_style_add_template_to' => 'If you are adding a new template to use with this module, please specify the style(s) you would like to add this template to here.<br />To select more than one style, hold down the \'Ctrl\' key while selecting styles with your mouse.',
	'serialize' => 'Serialize',
	'setting' => 'setting',
	'setting_customized_pages' => 'This setting has been customized in the following page(s): ',
	'setting_customized_pages_desc' => 'This setting has previously had a custom value set for it in the page(s) listed above. The value set in any of these pages will override the value set here. To change the value of this setting on these pages, you must edit the page and change the value there, or revert the setting on that page so it will use the value set here.',
	'settings_customized_marked_with_asterisk' => 'The settings below marked with a &quot;*&quot; have been customized on this page and the value set here will override the default setting on this page. If you wish to revert any of these settings so that the default value will be used for this page again, check the &quot;Use Default&quot; checkbox to the right of the setting\'s title and then save the page.',
	'show_all_settings' => 'Show All Settings',
	'showing_w_x_to_y_of_z' => 'Showing {1} {2} to {3} of {4}',
	'simple_calendar' => 'Simple Calendar',
	'start' => 'Start',
	'style_to_install_to' => 'Style to install templates to
<div>If this module has any templates included, you must choose which style(s) you would like to install these templates to here.<br />To select more than one style, hold down the \'Ctrl\' key while selecting styles with your mouse.</div>',
	'thread_title' => 'Thread Title',
	'template' => 'Template',
	'template_allows_template' => 'Template {1}s allow you to include a template from the vBulletin Style Manager to be displayed as the content for the {2}. Template {1}s are recommended for more advanced HTML coding, and also allows you the benefits of using vBulletin\'s &quot;<a href="http://www.vbulletin.com/docs/html/template_conditionals" target="_blank">Template Conditionals</a>&quot; for dynamic content.',
	'template_content' => 'Template Content
<div>If you are adding a new {1} and the template does not already exist, you may enter the content for that template here. If the template already exists, simply leave this field blank. Please note as well that any changes to this template will need to be made via your \'Style Manager\'.</div>',
	'template_title' => 'Template Title',
	'note_templates_should_use_format' => 'Also note that all templates should use the following format if this setting is enabled:',
	'temlate_title_desc' => 'Enter the name of the template that you wish to display for the content of this page here.',
	'template_to_include' => 'Template to Include<div>Enter the name of the template that you wish to display with this module here. Note that all templates must be prefixed with \'adv_portal\' and that it is not necessary to enter this prefix.<br />Example: If your template is called \'adv_portal_games\', enter \'games\' in the box to the right.</div>',
	'templates_used' => 'Templates Used
<div>Here you may enter a list of any templates that are called within your PHP file and used in this module. This is necessary to cache the templates as well as figure out which templates belong to this module when downloading modules. Separate each template with a carriage return (new line).',
	'this_module' => 'this module',
	'this_script_integration_method' => 'THIS_SCRIPT Integration Method',
	'this_script_integration_method_desc' => 'Any default vBulletin file (and most vB hacks) will define the constant &quot;THIS_SCRIPT&quot; at or near the top of the file to help identify it. If you wish to integrate files but cannot use the filename options above, simply open the file you wish to integrate, look for the THIS_SCRIPT constant near the top, and enter the value here. Separate each THIS_SCRIPT value with a carriage return (new line).<br /><br />Example code to look for:<hr width="40%" align="{1}"><div>define(\'THIS_SCRIPT\', \'<strong><i>value</i></strong>\');</div><hr width="40%" align="{1}"><div style="padding-top:4px">From this example, you would enter \'value\' (without the quotes) in the box to the right.',
	'title_row_colspan' => 'Title Row Colspan
<div>If the module will have more than one table cell in the code which is output, you may set a colspan value here that will be placed in the main title row of the wrapper template.</div>',
	'to_begin_selecting_threads' => 'To begin selecting threads to display, first choose a forum to browse.',
	'to_remove_this_module' => 'To remove this module click the \'Remove Module\' button below.',
	'tool_downloads_module' => 'This tool will allow you to download a .xml or .module file which will contain all information (settings, templates, files, etc) that is associated with this module. This allows you to easily make backups of your modules and/or share your custom modules with others.',
	'tool_allows_copy_layouts' => 'This tool will allow you to copy your module layout and active modules from one page to others. Simply select the page that you wish to copy the layout from, check the page(s) that you wish to copy the module layout to, and then click &quot;Save&quot;.',
	'upload_module' => 'Upload Module',
	'urls' => 'URLs',
	'use_current_file_instead' => 'Use Current File Instead',
	'use_default' => 'Use Default',
	'use_default_style' => 'Use Default Style',
	'use_module_wrapper_must_be_enabled' => 'For this setting to have any effect, the "Use Module Wrapper Template" setting above must be enabled.\r\nWould you like to enable this setting now?',
	'use_module_wrapper_template' => 'Use Module Wrapper Template

<div>This option will &quot;wrap&quot; a template (\'<i>adv_portal_module_wrapper</i>\', unless an Alternative template is specified) around the output of this {1} template. This is intended to keep your modules uniform and make it easy to change the look of most all modules by editing one template.</div>',
	'usergroup_permissions' => 'Usergroup Permissions',
	'vba_dyna_copy' => 'This tool will allow you to import any module from your vBadvanced Dynamics instances for use with vBadvanced CMPS.',
	'vba_dyna_copy_module_text' => 'This tool will allow you to import any module from your vBadvanced Dynamics instances for use on vBadvanced CMPS pages. Simply select the module you would like to import and then click the button below.',
	'vba_dyna_module' => 'vBa Dynamics Module',
	'vbadvanced_cmps' => 'vBadvanced CMPS',
	'vbulletin_files_to_integrate' => 'vBulletin Files to Integrate',
	'vbulletin_files_to_integrate_desc' => 'Here you may select any file names from your vBulletin folder that you wish to integrate with the CMPS. To select more than one file, hold down the \'Ctrl\' key while selecting files with your mouse.',
	'vbulletin_forum_url' => 'vBulletin Forum URL',
	'version_info_unavailable' => 'vBadvanced version information is currently unavailable.',
	'view_edit_active_modules_on_this_page' => 'View / Edit Active Modules on This Page',
	'welcome_to_vba_cmps_control_panel' => 'Welcome to the vBadvanced CMPS Admin Control Panel',
	'wrap_table_around_content' => 'Wrap a Table Around Content<div class="smallfont">Turn this option on if you would like to wrap opening and closing &lt;table&gt; tags around the content of this module. Note this should be enabled for modules designed for vBulletin 3 that use tables.</div>',
	'x_link' => '{1} Link
<div>If you would like the title of this {1} to link to another page on your site you may enter the file that this {1} should link to here.</div>',
	'x_module' => '{1} Module',
	'x_modules' => '{1} Modules',
	'x_options' => '{1} Options',
	'x_page' => '{1} Page',
	'x_pages' => '{1} Page(s)',
	'x_settings_customized_for_this_page' => '{1} settings customized for this page',
	'x_tools' => '{1} Tools',
	'x_total_threads' => '{1} Total Threads',
	'x_y_options' => '{2} {1} Options',
	'yes_all_attachments' => 'Yes, All Attachments',
	'yes_first_attach_only' => 'Yes, First Attachment Only',
	'your_custom_content' => 'your \'Custom Page Content\' module',
	'your_vba_version_up_to_date' => 'Your version of vBadvanced CMPS is up to date.'
);

$mainphrases['error'] = array(
	'adv_portal_cant_remove_default' => 'You can\'t remove your default page!',
	'adv_portal_cant_parent_page_itself' => 'You cannot create a page that it is its own parent. Please go back and select a different parent page for this page.',
	'adv_portal_choose_style' => 'You must choose the style in which you wish to install the templates for this module to.',
	'adv_portal_custom_page_inactive' => 'The &quot;Custom Page Content&quot; module is not active on this page. This module is what is used to display the content from your {1}, and this content will not be visible on the page unless this module is active.',
	'adv_portal_duplicate_identifier' => 'You already have a {1} with an identifier of \'{2}\'. Please select a different identifier.',
	'adv_portal_integration_successfully_saved' => 'Your integration settings have been successfully saved.',
	'adv_portal_invalid_cmps_url' => 'Invalid URL: <a href="{1}" target="_blank">{1}</a>',
	'adv_portal_invalid_file_path' => 'The path you have specified for your {1} path is not a valid file on your server. Please go back and enter the full path (NOT the URL) to this file.',
	'adv_portal_invalid_modfile' => 'The file you have uploaded is not a valid module file.',
	'adv_portal_layouts_copied_successfully' => 'Your module layout has been copied successfully.',
	'adv_portal_moddir_notwritable' => 'Your modules directory is not writable. Please chmod your modules directory to 777 and try again.',
	'adv_portal_module_saved_add_to_pages' => 'Your module has been successfully saved. Click &quot;Go Back&quot; to add another module, or click &quot;Continue&quot; to activate this module on your CMPS pages.',
	'adv_portal_must_choose_php_file_include' => 'You must choose a PHP file to include!',
	'adv_portal_must_choose_template_include' => 'You must choose a template to include!',
	'adv_portal_must_choose_title_for_module' => 'You must choose a title for your module!',
	'adv_portal_must_choose_x_type' => 'You must choose a the type of {1} that you wish to add!',
	'adv_portal_must_enter_x_for_page' => 'You must choose a {1} for your page!',
	'adv_portal_no_files_to_integrate' => 'You have not selected anything to integrate.',
	'adv_portal_no_valid_integration_pages' => 'You do not currently have any pages that meet the qualifications necessary to be used for integration. <a href="vba_cmps_admin.php?do=addpage&type=module">Click here</a> to add a new &quot;Module&quot; page to be used for the integration.',
	'adv_portal_must_select_file_integrate' => 'You have not selected a CMPS page to integrate with one or more of your files. Please go back and ensure that you have selected a CMPS page to integrate with each filename and/or THIS_SCRIPT constant that you have chosen.',
	'adv_portal_old_modules_found' => 'One or more modules on this page have been disabled by the Administrator. These modules have been removed from your layout.',
	'adv_portal_page_saved_but_problems_found' => 'Your page has been saved, but the following problems were found: {1}',
	'adv_portal_required_modules_not_found' => 'One or more required modules were not found to be active on this page. These modules have been added to the bottom of the center column.',
	'adv_portal_suhosin' => 'A required field called pageid is missing or has an invalid value.<br />Please see the <a href="http://www.vbadvanced.com/forum/faq.php?faq=vba_trouble#faq_suhosin" target="_blank">vBadvanced FAQ</a> for more information regarding this error.',
	'adv_portal_template_exists' => 'A template named {1} already exists in this style. Please choose a different name for your template, a different style to install this template to, or simply leave the \'Template Content\' field blank. Please note that you may also edit this template through your \'Style Manager\'.',
	'adv_portal_threads_save_page' => 'We\'re sorry, but since you are adding a new page and this page has not yet been created, the threads cannot be saved properly. Please go back and save the page you were creating first. You will then you will be able to pick specific threads once you go back to edit the page.',
	'adv_portal_x_rebuilt' => '{1} Rebuilt'
);

$mainphrases['cphome'] = array(
	'vba_cmps' => 'vBa CMPS',
	'edit_modules' => 'Edit Modules',
	'edit_pages' => 'Edit Pages',
	'add_module' => 'Add Module',
	'add_page' => 'Add Page',
	'default_settings' => 'Default Settings',
	'download_upload_module' => 'Download / Upload Module',
	'quick_permissions_editor' => 'Quick Permissions Editor',
	'copy_module_layouts' => 'Copy Module Layouts',
	'integration' => 'Integration'
);

$mainphrases['vbsettings'] = array(
	'settinggroup_adv_portal_admin' => 'Admin CP Options',
	'settinggroup_adv_portal_main' => 'Main Options',
	'settinggroup_adv_portal_style' => 'Style Options',
	'settinggroup_adv_global_cmps' => 'Global vBadvanced Settings'
);

$mainphrases['style'] = array(
	'group_adv_cmps' => 'vBadvanced CMPS'
);

// ##### Settings #############################################################
$mainsettings['adv_global'] = array(
	'global_header_replace' => array(
		'title' => 'Header Replacements',
		'description' => 'Here you may enter a list of filenames that may appear in your header that should be prefixed with your Forum\'s URL.',
		'value' => "album.php\r\ncalendar.php\r\ncontent.php\r\nfaq.php\r\nforumdisplay.php\r\ngroup.php\r\nlogin.php\r\nmember.php\r\nmemberlist.php\r\nonline.php\r\nprivate.php\r\nprofile.php\r\nregister.php\r\nsearch.php\r\nsubscription.php\r\ntags.php\r\nusercp.php",
		'optioncode' => 'textarea',
		'displayorder' => '1'
	),
	'global_navbar_replace' => array(
		'title' => 'Navbar Replacements',
		'description' => 'Here you may enter a list of filenames that should be prefixed with your Forum\'s URL.',
		'value' => "album.php\r\ncalendar.php\r\ncontent.php\r\nfaq.php\r\nforumdisplay.php\r\ngroup.php\r\nlogin.php\r\nmember.php\r\nmemberlist.php\r\nonline.php\r\nprivate.php\r\nprofile.php\r\nregister.php\r\nsearch.php\r\nsubscription.php\r\ntags.php\r\nusercp.php",
		'optioncode' => 'textarea',
		'displayorder' => '2'
	),
	'global_footer_replace' => array(
		'title' => 'Footer Replacements',
		'description' => 'Here you may enter a list of filenames that may appear in your footer that should be prefixed with your Forum\'s URL.',
		'value' => "archive\r\nsendmessage.php\r\nprofile.php",
		'optioncode' => 'textarea',
		'displayorder' => '3'
	)
);


$mainsettings['adv_portal_birthdays'] = array(
	'portal_birth_newline' => array(
		'title' => 'Show Each Member on a New Line',
		'description' => 'Turn this option on if you would like each member with a birthday today to be displayed on a new line. Otherwise members will be separated by a comma.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '10',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_calendar'] = array(
	'portal_calendarid' => array(
		'title' => 'Calendar to Display',
		'description' => 'Please select which calendar you would like to display events from in your mini calendar.',
		'value' => '1',
		'optioncode' => 'calendarselect',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_calendar_birthdays' => array(
		'title' => 'Show Birthdays',
		'description' => 'Turn this option on to include your member\'s birthdays in the calendar events.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_calendar_cache' => array(
		'title' => 'Calendar Cache Update Frequency',
		'description' => 'Enter the amount of time (in hours) between calendar cache updates. This will allow your calendar events and data to be cached, preventing a number of queries from being executed each time this module is loaded. The downside to caching this data is that new events or birthdays will not be added until the next time the cache is updated. Set this option to 0 to disable calendar caching.',
		'value' => '12',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_latestthreads'] = array(
	'portal_threadids' => array(
		'title' => 'Threads',
		'description' => 'Here you may select specific threads to be displayed with this module.',
		'value' => 'a:0:{}',
		'optioncode' => 'threadselect',
		'displayorder' => '10',
		'serialize' => 1
	),
	'portal_threads_forumids' => array(
		'title' => 'Recent Threads Forums',
		'description' => 'Here you may select the forum(s) in which you would like to display recent threads from. To select more than one forum, hold down your \'Ctrl\' key while selecting the forums with your mouse. Leave this option blank to select threads from all forums.',
		'value' => '',
		'optioncode' => 'forumselect',
		'displayorder' => '20',
		'serialize' => 1
	),
	'portal_threads_maxthreads' => array(
		'title' => 'Number of Threads to Display',
		'description' => 'The maximum number of latest threads that you would like to display.',
		'value' => '10',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_threads_cutoffdate' => array(
		'title' => 'Cut-Off Date',
		'description' => 'Here you may enter a number of days that represents a threshold for recent threads. Any threads that have not had a reply since this number of days will not be included. This helps to prevent large table scans on forums with a large number of threads. Set this option to 0 for no limit.',
		'value' => '30',
		'optioncode' => '',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_threads_maxchars' => array(
		'title' => 'Maximum Characters of Thread Title to Display',
		'description' => 'The maximum number of characters that should be displayed before the rest of a thread\'s title is replaced by \'...\'. Set this to 0 to display the entire title.',
		'value' => '25',
		'optioncode' => '',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_threads_maxwordchars' => array(
		'title' => 'Maximum Characters of Each Word',
		'description' => 'The maximum number of characters a word may contain. Any threads that contain a word longer than the value set here will be trimmed to that value. This helps to prevent threads with extremely long words from stretching out the page.',
		'value' => '20',
		'optioncode' => '',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_threads_orderby' => array(
		'title' => 'Thread Display Order',
		'description' => 'The field in which threads should be ordered by.',
		'value' => 'lastpost',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'lastpost\', \'selected=\\"selected\\"\'). " value=\\"lastpost\\">$vbphrase[last_post]</option>
	<option " . iif($setting[value] == \'dateline\', \'selected=\\"selected\\"\'). " value=\\"dateline\\">$vbphrase[date_created]</option>
	<option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"title\\">$vbphrase[thread_title]</option>
	<option " . iif($setting[value] == \'voteavg\', \'selected=\\"selected\\"\'). " value=\\"voteavg\\">$vbphrase[rating]</option>
	<option " . iif($setting[value] == \'replycount\', \'selected=\\"selected\\"\'). " value=\\"replycount\\">$vbphrase[replies]</option>
	<option " . iif($setting[value] == \'views\', \'selected=\\"selected\\"\'). " value=\\"views\\">$vbphrase[views]</option>
</select>',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_threads_direction' => array(
		'title' => 'Thread Display Direction',
		'description' => 'The direction in which threads should appear in.',
		'value' => 'DESC',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">$vbphrase[ascending]</option>
	<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">$vbphrase[descending]</option>
</select>',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_threads_expanded' => array(
		'title' => 'Use Expanded Threads Template',
		'description' => 'This option can be used to switch between the \'adv_portal_recthreads_lean\' and \'adv_portal_recthreads_exp\' templates. Set this option to \'Dynamic\' if you would like for the module to try to automatically determine the best setting based on the size of the column it is activated in.',
		'value' => '2',
		'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[lean]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[expanded]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[dynamic]</label>
</div>',
		'displayorder' => '90',
		'serialize' => 0
	),
	'portal_applypermissions' => array(
		'title' => 'Apply Forum Permissions',
		'description' => 'Turn this option on to take your forum permissions into account and only show threads which the user has permission to view. ',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '100',
		'serialize' => 0
	),
	'portal_threads_threadstarter' => array(
		'title' => 'Show Thread Starter',
		'description' => 'Turn this option on to display the thread starter\'s username and a link to their profile.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '110',
		'serialize' => 0
	),
	'portal_threads_showdate' => array(
		'title' => 'Show Date & Time',
		'description' => 'Shows the time and date the thread was created.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '120',
		'serialize' => 0
	),
	'portal_threads_views' => array(
		'title' => 'Show Number of Views',
		'description' => 'Turn this option on to display the number of times the thread has been viewed.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '130',
		'serialize' => 0
	),
	'portal_threads_replies' => array(
		'title' => 'Show Number of Replies',
		'description' => 'Turn this option on to display the number of replies to a thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '140',
		'serialize' => 0
	),
	'portal_threads_lastpost' => array(
		'title' => 'Show Last Post Info',
		'description' => 'This option will display the last poster and time at which the last post was made.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '150',
		'serialize' => 0
	),
	'portal_threads_showforum' => array(
		'title' => 'Show Forum',
		'description' => 'Turn this option on to display the name of and link to the forum that the post was made in.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '160',
		'serialize' => 0
	),
	'portal_threads_showpreview' => array(
		'title' => 'Show Preview of Threads',
		'description' => 'Turn this option on to show a preview of the first post in the thread when you hold your mouse over the title of the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '170',
		'serialize' => 0
	),
	'portal_threads_showicon' => array(
		'title' => 'Show Thread Icons',
		'description' => 'Turn this option on to display the icon that was selected for the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '180',
		'serialize' => 0
	),
	'portal_threads_showsubscribed' => array(
		'title' => 'Show Subscribed Icon',
		'description' => 'Turn this option on to display a \'subscribed\' icon next to the thread title if a user is subscribed to the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '190',
		'serialize' => 0
	),
	'portal_threads_showrating' => array(
		'title' => 'Show Thread Ratings',
		'description' => 'Turn this option on to display the thread\'s rating.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '200',
		'serialize' => 0
	),
	'portal_threads_stickyicon' => array(
		'title' => 'Show Sticky Icon',
		'description' => 'Turn this option on if you would like to display the \'sticky\' icon next to threads that have been marked as &quot;sticky&quot;.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '210',
		'serialize' => 0
	),
	'portal_threads_multipage' => array(
		'title' => 'Show Multi-Page Thread Links',
		'description' => 'Turn this option on to show a link to each individual page for threads that have span multiple pages.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '220',
		'serialize' => 0
	),
	'portal_threads_showpaperclip' => array(
		'title' => 'Show Attachment Paperclip',
		'description' => 'Turn this option on to display the small \'paperclip\' icon showing the number of attachments in a thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '230',
		'serialize' => 0
	),
	'portal_threads_newpostarrow' => array(
		'title' => 'Show New Post Arrow',
		'description' => 'Turn this option on to display the "New Post" icon to allow users to go stright to the first unread post in the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '240',
		'serialize' => 0
	),
	'portal_threads_prefix' => array(
		'title' => 'Show Prefix',
		'description' => 'Turn this option on if you would like to display the thread\'s prefix.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '250',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_navigation'] = array(
	'portal_navigation_excludepages' => array(
		'title' => 'Pages to Exclude',
		'description' => 'Here you may select any pages which you do not wish to display with this module. To select more than one page, hold down your \'Ctrl\' key while selecting the pages with your mouse.',
		'value' => '',
		'optioncode' => 'pageselect',
		'displayorder' => '10',
		'serialize' => 1
	),
	'portal_navigation_mark1' => array(
		'title' => 'Level 1 Mark',
		'description' => 'This is what will be displayed next to a page\'s title if the page does not have a parent page, or is a custom link and has value of 1 for its level.',
		'value' => '&raquo;',
		'optioncode' => '',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_navigation_mark2' => array(
		'title' => 'Level 2+ Mark',
		'description' => 'This is what will be displayed next to a page\'s title if the page has a parent, or is a custom link and has value of 2 or higher for its level.',
		'value' => '&gt;',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_navigation_addpages' => array(
		'title' => 'Additional Pages',
		'description' => 'Here you may enter any additional pages which you would like to display a link to in this module. Enter the URL you would like to link to under the \'Link\' column and the text to display under the \'Text\' column. The \'Level\' option below will indent the link the specified number spaces, giving the link the appearance of "belonging" to the first page above it with a lower level. Note that you may leave the URL field blank to display text without a link (useful for headings).',
		'value' => 'a:3:{i:0;a:4:{s:5:"order";s:1:"1";s:5:"level";s:1:"1";s:4:"link";s:65:"{$vbulletin->options[bburl]}/{$vbulletin->options[forumhome]}.php";s:4:"text";s:5:"Forum";}i:1;a:4:{s:5:"order";s:1:"2";s:5:"level";s:1:"2";s:4:"link";s:39:"{$vbulletin->options[bburl]}/usercp.php";s:4:"text";s:7:"User CP";}i:2;a:4:{s:5:"order";s:1:"3";s:5:"level";s:1:"2";s:4:"link";s:36:"{$vbulletin->options[bburl]}/faq.php";s:4:"text";s:3:"FAQ";}}',
		'optioncode' => 'pageselect_add',
		'displayorder' => '40',
		'serialize' => 1
	)
);


$mainsettings['adv_portal_news'] = array(
	'portal_threadids' => array(
		'title' => 'Threads',
		'description' => 'Here you may select specific threads to be displayed with this module.',
		'value' => 'a:0:{}',
		'optioncode' => 'threadselect',
		'displayorder' => '10',
		'serialize' => 1
	),
	'portal_news_forumid' => array(
		'title' => 'News Forum(s)',
		'description' => 'Here you may select the forum(s) in which you would like to display threads from in your news module. To select more than one forum, hold down your \'Ctrl\' key while selecting the forums with your mouse.',
		'value' => 'a:0:{}',
		'optioncode' => 'forumselect',
		'displayorder' => '20',
		'serialize' => 1
	),
	'portal_news_maxposts' => array(
		'title' => 'Maximum Number of Threads to Display',
		'description' => 'The maximum number of news threads to display. Setting this option to 0 will disable the module.',
		'value' => '5',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_news_threadsperpage' => array(
		'title' => 'Enable News Pagination',
		'description' => 'This option will allow you to enable a small page navigation section under your news module with links to additional pages of news threads. Enter the maximum number of pages that you would like to display here to enable this option.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_news_cutoffdate' => array(
		'title' => 'Cut-Off Date',
		'description' => 'Here you may enter a number of days that represents a threshold for news posts. Any threads before the current date minus this number of days will not be included. This helps to prevent large table scans on forums with a large number of threads. Set this option to 0 for no limit.',
		'value' => '90',
		'optioncode' => '',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_news_maxchars' => array(
		'title' => 'Maximum Characters to Display',
		'description' => 'The maximum number of characters that you would like to display in a news post before it is replaced by the \'...[Read More]\' link. Set this option to 0 to display the entire message.',
		'value' => '500',
		'optioncode' => '',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_news_dateformat' => array(
		'title' => 'Date & Time Format',
		'description' => 'The format in which the date and time will displayed in your news posts. Leave this blank if you do not wish to display the date/time a post was made.',
		'value' => 'M d, Y - g:i A',
		'optioncode' => '',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_news_orderby' => array(
		'title' => 'Thread Display Order',
		'description' => 'The field in which threads should be ordered by.',
		'value' => 'postdateline',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'lastpost\', \'selected=\\"selected\\"\'). " value=\\"lastpost\\">$vbphrase[last_post]</option>
	<option " . iif($setting[value] == \'postdateline\', \'selected=\\"selected\\"\'). " value=\\"postdateline\\">$vbphrase[date_created]</option>
	<option " . iif($setting[value] == \'title\', \'selected=\\"selected\\"\'). " value=\\"title\\">$vbphrase[thread_title]</option>
	<option " . iif($setting[value] == \'voteavg\', \'selected=\\"selected\\"\'). " value=\\"voteavg\\">$vbphrase[rating]</option>
	<option " . iif($setting[value] == \'replycount\', \'selected=\\"selected\\"\'). " value=\\"replycount\\">$vbphrase[replies]</option>
	<option " . iif($setting[value] == \'views\', \'selected=\\"selected\\"\'). " value=\\"views\\">$vbphrase[views]</option>
</select>',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_news_direction' => array(
		'title' => 'Thread Display Direction',
		'description' => 'The direction in which threads should appear in.',
		'value' => 'DESC',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">$vbphrase[ascending]</option>
	<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">$vbphrase[descending]</option>
</select>',
		'displayorder' => '90',
		'serialize' => 0
	),
	'portal_news_showattachments' => array(
		'title' => 'Enable Attachments',
		'description' => 'Turn this option on to display the attachments associated with each news post.',
		'value' => '0',
		'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[no]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[yes_first_attach_only]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[yes_all_attachments]</label>
</div>',
		'displayorder' => '100',
		'serialize' => 0
	),
	'portal_applypermissions' => array(
		'title' => 'Apply Forum Permissions',
		'description' => 'Turn this option on to take your forum permissions into account and only show threads which the user has permission to view. ',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '110',
		'serialize' => 0
	),
	'portal_news_allowreplies' => array(
		'title' => 'Show Reply Info',
		'description' => 'Turn this option on to display the number of replies that have been made to each post.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '120',
		'serialize' => 0
	),
	'portal_news_showviews' => array(
		'title' => 'Show Number of Views',
		'description' => 'Turn this option on to display the number of times a news thread has been viewed.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '130',
		'serialize' => 0
	),
	'portal_news_showavatar' => array(
		'title' => 'Show Avatars',
		'description' => 'Turn this option on to display the poster\'s avatar with your news posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '140',
		'serialize' => 0
	),
	'portal_news_showicon' => array(
		'title' => 'Show Post Icons',
		'description' => 'Turn this option on to display the icon selected for your news posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '150',
		'serialize' => 0
	),
	'portal_news_showrating' => array(
		'title' => 'Show Ratings',
		'description' => 'Turn this option on to display the post\'s rating.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '160',
		'serialize' => 0
	),
	'portal_news_showsubscribed' => array(
		'title' => 'Show Subscribed Thread Icon',
		'description' => 'Turn this option on to display a \'subscribed\' icon next to the thread title if a user is subscribed to the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '170',
		'serialize' => 0
	),
	'portal_news_showsendfriend' => array(
		'title' => 'Show Send to Friend Link',
		'description' => 'Turn this option on to display the \'send to friend\' icon with a link to allow users to email a link to the thread to friends.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '190',
		'serialize' => 0
	),
	'portal_news_showsignature' => array(
		'title' => 'Show Signatures',
		'description' => 'Turn this option on to show the poster\'s signature with the post. Note that the \'Show your signature\' option when making a post can still be used to disable signatures in selected posts.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '200',
		'serialize' => 0
	),
	'portal_news_sticky' => array(
		'title' => 'Show Sticky Posts on Top',
		'description' => 'Turn this option on to cause threads that have been made sticky to appear at the top of the news section.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '210',
		'serialize' => 0
	),
	'portal_news_legacy' => array(
		'title' => 'Separate News Posts',
		'description' => 'Turn this option on to display the posts separately rather than grouped together.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '220',
		'serialize' => 0
	),
	'portal_news_attachpaperclip' => array(
		'title' => 'Show Attachment Paperclip',
		'description' => 'Turn this option on to display the small \'paperclip\' icon showing the number of attachments in a thread.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '230',
		'serialize' => 0
	),
	'portal_news_bbcode_attach' => array(
		'title' => 'Enable [ATTACH] BB Code Tags',
		'description' => 'Turn this option on if you would like to enable [ATTACH] BB code tags.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '240',
		'serialize' => 0
	),
	'portal_news_prefix' => array(
		'title' => 'Show Prefix',
		'description' => 'Turn this option on if you would like to display the thread\'s prefix.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '250',
		'serialize' => 0
	),
	'portal_news_postcache' => array(
		'title' => 'Use Post Cache',
		'description' => 'This option will cause news posts to use the vBulletin post cache (if enabled) rather than parsing the BB code each time the page is loaded. This will improve performance on web sites with a lot of news posts, but will disable the BB code options below and cause the module to use your news forums\' settings.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '260',
		'serialize' => 0
	),
	'portal_news_enablehtml' => array(
		'title' => 'Allow HTML',
		'description' => 'Turn this option on to allow HTML to be parsed in posts.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '270',
		'serialize' => 0
	),
	'portal_news_enablevbcode' => array(
		'title' => 'Allow BB Code',
		'description' => 'Turn this option on to allow BB code to be parsed in posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '280',
		'serialize' => 0
	),
	'portal_news_enablevbimage' => array(
		'title' => 'Allow [IMG] Code',
		'description' => 'Turn this option on to allow the [IMG] code in posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '290',
		'serialize' => 0
	),
	'portal_news_enablesmilies' => array(
		'title' => 'Allow Smilies',
		'description' => 'Turn this option on to allow smilies in posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '300',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_newsarchive'] = array(
	'portal_news_enablearchive' => array(
		'title' => 'Number of Archived News Posts to Display',
		'description' => 'The number of news posts you would like to display in the News Archive. Set this to 0 to disable the News Archive.',
		'value' => '5',
		'optioncode' => '',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_archive_maxchars' => array(
		'title' => 'Maximum Characters of Thread Title to Display',
		'description' => 'The maximum number of characters that should be displayed before the rest of a thread\'s title is replaced by \'...\'. Set this to 0 to display the entire title.',
		'value' => '25',
		'optioncode' => '',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_archive_expanded' => array(
		'title' => 'Use Expanded Archive Template',
		'description' => 'This option can be used to switch between the \'adv_portal_archivebits_lean\' and \'adv_portal_archivebits_exp\' templates. Set this option to \'Dynamic\' if you would like for the module to try to automatically determine the best setting based on the size of the column it is activated in.',
		'value' => '2',
		'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[lean]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[expanded]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[dynamic]</label>
</div>',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_news_archivepreview' => array(
		'title' => 'Show Preview in Archive?',
		'description' => 'Turn this option on to show a preview of the first post in the archived thread when you hold your mouse over the title of the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_archive_threadstarter' => array(
		'title' => 'Show Thread Starter',
		'description' => 'Turn this option on to display the thread starter\'s username and a link to their profile.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_archive_showdate' => array(
		'title' => 'Show Date & Time',
		'description' => 'Turn this option on to display the date and time the post was made.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_archive_showviews' => array(
		'title' => 'Show Views',
		'description' => 'Turn this option on to display the number of times that the archived thread has been viewed.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_archive_showreplies' => array(
		'title' => 'Show Replies',
		'description' => 'Turn this option on to display the number of replies that have been made to the archived thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_newsarchive_lastpost' => array(
		'title' => 'Show Last Post Info',
		'description' => 'Turn this option on to display the last poster and time at which the last post was made.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '90',
		'serialize' => 0
	),
	'portal_newsarchive_showforum' => array(
		'title' => 'Show Forum',
		'description' => 'This option will display the name of and link to the forum that the thread was made in.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '100',
		'serialize' => 0
	),
	'portal_archive_showrating' => array(
		'title' => 'Show Ratings',
		'description' => 'Turn this option on to display ratings with your archived threads.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '110',
		'serialize' => 0
	),
	'portal_archive_showicon' => array(
		'title' => 'Show Post Icons',
		'description' => 'Turn this option on to display the icon selected for your news archive threads.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '120',
		'serialize' => 0
	),
	'portal_archive_showsubscribed' => array(
		'title' => 'Show Subscribed Thread Icon',
		'description' => 'Turn this option on to display a \'subscribed\' icon next to the thread title if a user is subscribed to the thread.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '130',
		'serialize' => 0
	),
	'portal_archive_stickyicon' => array(
		'title' => 'Show Sticky Icon',
		'description' => 'Turn this option on if you would like to display the \'sticky\' icon next to threads that have been marked as &quot;sticky&quot;.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '140',
		'serialize' => 0
	),
	'portal_archive_multipage' => array(
		'title' => 'Show Multi-Page Thread Links',
		'description' => 'Turn this option on to show a link to each individual page for threads that have span multiple pages.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '150',
		'serialize' => 0
	),
	'portal_archive_attachpaperclip' => array(
		'title' => 'Show Attachment Paperclip',
		'description' => 'Turn this option on to display the small \'paperclip\' icon showing the number of attachments in a thread.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '160',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_poll'] = array(
	'portal_threadids' => array(
		'title' => 'Threads',
		'description' => 'Here you may select specific threads to be displayed with this module.',
		'value' => '',
		'optioncode' => 'threadselect',
		'displayorder' => '10',
		'serialize' => 1
	),
	'portal_poll_forumid' => array(
		'title' => 'Polls Forum(s)',
		'description' => 'Here you may select the forum(s) in which you would like to display polls from. To select more than one forum, hold down your \'Ctrl\' key while selecting the forums with your mouse.',
		'value' => '',
		'optioncode' => 'forumselect',
		'displayorder' => '20',
		'serialize' => 1
	),
	'portal_poll_cutoffdate' => array(
		'title' => 'Cut-Off Date',
		'description' => 'Here you may enter a number of days that represents a threshold for polls. Any polls that were created before the current date minus this number of days will not be included. This helps to prevent large table scans on forums with a large number of threads. Set this option to 0 for no limit.',
		'value' => '30',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_poll_wraptitle' => array(
		'title' => 'Poll Title Maximum Number of Characters',
		'description' => 'Enter the maximum number of characters that should be allowed in a poll title before &quot;wrapping&quot; inserting a space so that the text may be split into multiple lines. Enter 0 to disable word wrapping.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_poll_wrapchoices' => array(
		'title' => 'Poll Choices Maximum Number of Characters',
		'description' => 'Enter the maximum number of characters that should be allowed in a poll choice before &quot;wrapping&quot; inserting a space so that the text may be split into multiple lines. Enter 0 to disable word wrapping.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_poll_orderby' => array(
		'title' => 'Polls Display Order',
		'description' => 'The order in which the poll should be selected.',
		'value' => 'dateline',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'dateline\', \'selected=\\"selected\\"\'). " value=\\"dateline\\">$vbphrase[date_created]</option>
	<option " . iif($setting[value] == \'votedate\', \'selected=\\"selected\\"\'). " value=\\"votedate\\">$vbphrase[last_vote]</option>
	<option " . iif($setting[value] == \'rand\', \'selected=\\"selected\\"\'). " value=\\"rand\\">$vbphrase[random]</option>
</select>',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_poll_direction' => array(
		'title' => 'Polls Display Direction',
		'description' => 'The direction in which the poll order should be ordered by.',
		'value' => 'DESC',
		'optioncode' => '<select name=\\"$name\\" " . $jsdefault_onchange . " class=\\"bginput\\" tabindex=\\"1\\">
	<option " . iif($setting[value] == \'ASC\', \'selected=\\"selected\\"\'). " value=\\"ASC\\">$vbphrase[ascending]</option>
	<option " . iif($setting[value] == \'DESC\', \'selected=\\"selected\\"\'). " value=\\"DESC\\">$vbphrase[descending]</option>
</select>',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_applypermissions' => array(
		'title' => 'Apply Forum Permissions',
		'description' => 'Turn this option on to take your forum permissions into account and only show threads which the user has permission to view. ',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_poll_allowclosed' => array(
		'title' => 'Allow Closed Polls to be Shown',
		'description' => 'Turn this option on if you would like to allow for polls that are closed to be displayed.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '90',
		'serialize' => 0
	),
	'portal_poll_allowreplies' => array(
		'title' => 'Show Reply Info',
		'description' => 'This option will show the \'Reply to this poll\' link on your poll giving users a link to quickly post a reply about the poll.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '100',
		'serialize' => 0
	),
	'portal_poll_allowsmilies' => array(
		'title' => 'Allow Smilies',
		'description' => 'Turn this option on to allow smilies in poll options.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '110',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_stats'] = array(
	'portal_stats_updatefrequency' => array(
		'title' => 'Top Poster Update Frequency',
		'description' => 'To help prevent large table scans, the top poster is only updated once every few hours, then that information stored in a cache. Here you may specify the number of hours between each check to see if there is a new top poster. Set this option to 0 if you wish to disable it and always perform a query to find the top poster.',
		'value' => '24',
		'optioncode' => '',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_stats_topposter_posts' => array(
		'title' => 'Also Cache Top Poster Postcount?',
		'description' => 'Turn this option on if you also wish to cache the top poster\'s postcount. Although the MySQL query to fetch the current top poster\'s information is not intensive, larger sites may still wish to cache this data as well to prevent a query. The downside to caching this data is that the top poster\'s post count will not always be accurate.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_stats_cacheforums' => array(
		'title' => 'Forum Cache Update Frequency',
		'description' => 'If you wish to cache the forums stats in this module (total threads &amp; posts), enter the number of hours that you wish to wait between updates. The query to gather this data is not generally very server intensive, but larger web sites or web sites with 100\'s of forums may want to enable this for better performance.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_stats_forumperms' => array(
		'title' => 'Apply Forum Permissions',
		'description' => 'Turn this option on to take your forum permissions into account and only show stats from forums which the user has permission to view.<br />
Note that this setting will not have an effect if the \'Forum Cache Update Frequency\' setting above is enabled and stats from all forums will be counted.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_stats_threads' => array(
		'title' => 'Show Number of Threads',
		'description' => 'Turn this option on if you would like to display the total number of threads in your forums.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_stats_posts' => array(
		'title' => 'Show Number of Posts',
		'description' => 'Turn this option on if you would like to display the total number of threads in your forums.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_stats_members' => array(
		'title' => 'Show Number of Members',
		'description' => 'Turn this option on if you would like to display the total number of registered members.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_stats_newestmember' => array(
		'title' => 'Show Newest Member',
		'description' => 'Turn this option on if you would like to display the name of your newest registered member.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_stats_topposter' => array(
		'title' => 'Show Top Poster',
		'description' => 'Turn this option on if you would like to display the member with the most posts in your forum.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '90',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_welcomeblock'] = array(
	'portal_welcome_lastvisit_date' => array(
		'title' => 'Last Visit Date Format',
		'description' => 'The format that you would like the date of the user\'s last visit displayed in.',
		'value' => 'm-d-y',
		'optioncode' => '',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_welcome_lastvisit_time' => array(
		'title' => 'Last Visit Time Format',
		'description' => 'The format that you would like the time of the user\'s last visit displayed in.',
		'value' => 'g:i a',
		'optioncode' => '',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_noavatarurl' => array(
		'title' => 'URL For &quot;No Avatar&quot; Image',
		'description' => 'If you would like to display a &quot;no avatar&quot; image in place of the avatar for users who do not have an avatar selected, enter the URL to that image here. Otherwise, leave this setting blank.<br />
Note: This setting will accept PHP variables, such as {$vbulletin->options[bburl]}.',
		'value' => '{$vbulletin->options[bburl]}/images/misc/noavatar.gif',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_welcome_expanded' => array(
		'title' => 'Use Expanded Welcomeblock Template',
		'description' => 'This option can be used to switch between the \'adv_portal_welcomeblock_lean\' and \'adv_portal_welcomeblock_expanded\' templates. Set this option to \'Dynamic\' if you would like for the module to try to automatically determine the best setting based on the size of the column it is activated in.',
		'value' => '2',
		'optioncode' => '<div class=\\"smallfont\\">
	<input name=\\"$name\\" id=\\"$setting[varname]_0\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 0, \'checked=\\"checked\\"\'). " value=\\"0\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_0\\">$vbphrase[lean]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_1\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 1, \'checked=\\"checked\\"\'). " value=\\"1\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_1\\">$vbphrase[expanded]</label><br />
	<input name=\\"$name\\" id=\\"$setting[varname]_2\\" type=\\"radio\\" " . $jsdefault_onchange . " " . iif($setting[value] == 2, \'checked=\\"checked\\"\'). " value=\\"2\\" tabindex=\\"1\\"><label for=\\"$setting[varname]_2\\">$vbphrase[dynamic]</label>
</div>',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_welcome_newpms' => array(
		'title' => 'Show Private Message Info',
		'description' => 'Turn this option on to display the member\'s private message info.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_welcome_avatar' => array(
		'title' => 'Show User\'s Avatar',
		'description' => 'Displays the user\'s avatar.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_welcome_newposts' => array(
		'title' => 'Show New Posts',
		'description' => 'Turn this option on to display the number of new posts since a user\'s last visit, along with a link to the posts.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '70',
		'serialize' => 0
	),
	'portal_welcome_rep' => array(
		'title' => 'Show Reputation',
		'description' => 'This option will allow you to display the user\'s current reputation image and reputation power.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '80',
		'serialize' => 0
	),
	'portal_welcome_rank' => array(
		'title' => 'Show User Rank',
		'description' => 'Turn this option on to display the member\'s rank image.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '90',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_main'] = array(
	'portal_integrate' => array(
		'title' => '',
		'description' => '',
		'value' => 'a:4:{s:11:"vbfilenames";a:0:{}s:11:"otfilenames";a:0:{}s:10:"thisscript";a:0:{}s:8:"vba_page";i:0;}',
		'optioncode' => 'hidden',
		'displayorder' => '0',
		'serialize' => 1
	),
	'portal_version' => array(
		'title' => 'vBadvanced CMPS version',
		'description' => 'Leave this setting alone.',
		'value' => '4.1.2',
		'optioncode' => 'hidden',
		'displayorder' => '0',
		'serialize' => 0
	),
	'portal_homeurl' => array(
		'title' => 'CMPS URL',
		'description' => 'The full URL to your CMPS file (originally named cmps_index.php).',
		'value' => '/cmps_index.php',
		'optioncode' => '',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_pagevar' => array(
		'title' => 'Page Variable',
		'description' => 'This is the variable that will be used in the URL to link to your new pages. For example, if this option is set to \'pageid\', then a link to a new page would look like this: http://yoursite.com/index.php?<strong>pageid</strong>=pagename',
		'value' => 'pageid',
		'optioncode' => '',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_column_array' => array(
		'title' => 'Location List',
		'description' => 'This option will allow you to add more columns or &quot;locations&quot; to display modules. Each location should have a unique &quot;Varname&quot; to help identify it within the template and phrases, and the &quot;Title&quot; you would like displayed throughout the Admin CP when editing layouts.
<div style="padding-top:4px">After adding new locations, you must edit your \'adv_portal\' template through your vBulletin Style Manager to add the variable \'{vb:raw home.<strong><i>Varname</i></strong>blocks}\' within the code where you would like that location to be displayed.</div>
<div style="padding-top:8px">Example: If you wanted to add a new &quot;bottom&quot; location, you would enter \'bottom\' for the Varname and \'Bottom Column\' for the Title.<br />
You would then add the variable \'{vb:raw home.bottomblocks}\' to your \'adv_portal\' template where you would like the modules in this location to be displayed.',
		'value' => 'a:3:{i:1;s:4:"left";i:2;s:6:"center";i:3;s:5:"right";}',
		'optioncode' => 'location_input',
		'displayorder' => '30',
		'serialize' => 1
	),
	'portal_outputglobals' => array(
		'title' => 'Portal Output Global Variables',
		'description' => 'If you have other hacks installed (especially to hacks located within the vBulletin navbar), it may be necessary to globalize some of the variables used in those hacks for the CMPS. You may enter a list of variables to globalize here. It is NOT necessary to add the $ mark before the variable name. Separate each variable with a carriage return (new line).',
		'value' => '',
		'optioncode' => 'textarea',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_use_module_function' => array(
		'title' => 'Process PHP File Modules Within A Function',
		'description' => 'Turning this option on will allow you to process your PHP file modules within a function, thus preserving global namespace and preventing conflicts when integrating with other vB pages or hacks. The downside to this is that some custom modules may not have the variables needed available to use if the variable has not been globalized within the function. Note that additional variables may be globalized by adding a new plugin to the \'vba_cmps_fetch_vba_module\' hook location.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_guestcache' => array(
		'title' => 'Enable Homepage Caching For Guests',
		'description' => 'This option will allow you to store a cached version of your homepage for guests, thus preventing modules from having to be processed as often and lowering the strain on the server for busier web sites. To enable this setting, enter the number of seconds that you would like to keep a cached version of the homepage before generating a new cached copy.',
		'value' => '0',
		'optioncode' => '',
		'displayorder' => '60',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_style'] = array(
	'portal_leftcolwidth' => array(
		'title' => 'Left Column Width',
		'description' => 'The width (in pixels or percentage) of your left column.',
		'value' => '175',
		'optioncode' => '',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_rightcolwidth' => array(
		'title' => 'Right Column Width',
		'description' => 'The width (in pixels or percentage) of your right column.',
		'value' => '175',
		'optioncode' => '',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_colspacing' => array(
		'title' => 'Horizontal Spacing Between Columns',
		'description' => 'The amount of space (in pixels) between the different columns.',
		'value' => '15',
		'optioncode' => '',
		'displayorder' => '30',
		'serialize' => 0
	),
	'portal_vspace' => array(
		'title' => 'Vertical Spacing Between Modules',
		'description' => 'The amount of space (in pixels) between your modules.',
		'value' => '15',
		'optioncode' => '',
		'displayorder' => '40',
		'serialize' => 0
	),
	'portal_blockbullet' => array(
		'title' => 'Module Title Bullet',
		'description' => 'Here you may enter any text or HTML code which you would like to appear next to the title of each module.',
		'value' => '&raquo;',
		'optioncode' => '',
		'displayorder' => '50',
		'serialize' => 0
	),
	'portal_shownavbar' => array(
		'title' => 'Enable Navbar',
		'description' => 'Turn this option on to enable the vBulletin navbar.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '60',
		'serialize' => 0
	),
	'portal_collapsemods' => array(
		'title' => 'Enable Collapsible Modules',
		'description' => 'This option will allow your modules to be collapsed/expanded by your users.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '70',
		'serialize' => 0
	)
);

$mainsettings['adv_portal_admin'] = array(
	'portal_replaceadmin' => array(
		'title' => 'Replace Admin CP Link',
		'description' => 'When enabled, this option will replace the \'Admin CP\' link in your footer template with a link to the CMPS admin file. Otherwise, turn this option off to have the link point to your normal vBulletin admincp folder.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '10',
		'serialize' => 0
	),
	'portal_admindd' => array(
		'title' => 'Enable Drag & Drop Modules',
		'description' => 'Turn this option on if you would like to use a &quot;drag &amp; drop&quot; javascript powered interface to arrange modules in the Admin CP. Otherwise a simple form will be used.',
		'value' => '1',
		'optioncode' => 'yesno',
		'displayorder' => '20',
		'serialize' => 0
	),
	'portal_admin_collapse' => array(
		'title' => 'Enable Collapsible Pages in Admin CP ',
		'description' => 'This option will allow you to collapse/expand pages in the "Edit Pages" section of the Admin CP. Web sites with a large number of CMPS pages should turn this on for performance reasons.',
		'value' => '0',
		'optioncode' => 'yesno',
		'displayorder' => '30',
		'serialize' => 0
	)
);

// ##### Setting Groups #######################################################
$adv_settinggroups = array(
	'adv_global' => 1,
	'adv_portal_main' => 2,
	'adv_portal_style' => 3,
	'adv_portal_admin' => 4
);

// ##### Hidden vB settings
$vba_vbsettings = array(
	'vba_portal_homeurl',
	'vba_portal_pagevar',
	'vba_portal_navtabs'
);

// ##### Modules ##############################################################
$vba_modules = array(
1 => array('title' => 'Online Users', 'identifier' => 'onlineusers', 'filename' => 'onlineusers.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_onlineusers forumhome_loggedinuser', 'active' => '1', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/online.php{$vbulletin->session->vars[sessionurl_q]}'),

2 => array('title' => 'Buddy List', 'identifier' => 'buddylist', 'filename' => 'onlineusers.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_buddylistbits', 'active' => '1', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/profile.php?{$vbulletin->session->vars[sessionurl]}do=buddylist'),

3 => array('title' => 'Mini Calendar', 'identifier' => 'calendar', 'filename' => 'minicalendar.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_calendar_week adv_portal_calendar_header adv_portal_calendar_day adv_portal_calendar_day_other calendar_smallmonth_day', 'active' => '1', 'colspan' => '7', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/calendar.php?{$vbulletin->session->vars[sessionurl]}c=$mod_options[portal_calendarid]', 'cssfiles' => 'calendar.css'),

4 => array('title' => 'News', 'identifier' => 'news', 'filename' => 'news.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_newsbits adv_portal_newsbits_attach_inline adv_portal_newsbits_attach_thumb bbcode bbcode_html bbcode_quote bbcode_quote_printable bbcode_php bbcode_video', 'active' => '1', 'useshell' => '1', 'options' => '23', 'cssfiles' => "postbit.css\r\nlightbox.css"),

5 => array('title' => 'Recent Threads', 'identifier' => 'latestthreads', 'filename' => 'recentthreads.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_recthreads_lean adv_portal_recthreads_exp adv_portal_recthreads_exp_head', 'active' => '1', 'useshell' => '1', 'options' => '18'),

6 => array('title' => 'Stats', 'identifier' => 'stats', 'filename' => 'stats.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_stats', 'active' => '1', 'useshell' => '1', 'options' => '2'),

7 => array('title' => 'Current Poll', 'identifier' => 'poll', 'filename' => 'currentpoll.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_poll adv_portal_pollresult adv_portal_polloption adv_portal_polloption_multiple', 'active' => '1', 'formcode' => '<form action="{$vbulletin->options[bburl]}/poll.php" method="post"><input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />', 'useshell' => '1', 'options' => '23', 'cssfiles' => 'poll.css'),

8 => array('title' => 'Quick Moderation', 'filename' => 'moderate.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_moderation', 'active' => '1', 'useshell' => '1', 'options' => '4'),

9 => array('title' => 'Welcome Block', 'identifier' => 'welcomeblock', 'filename' => 'welcomeblock.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_welcomeblock_lean adv_portal_welcomeblock_expanded postbit_reputation', 'active' => '1', 'colspan' => '2', 'formcode' => '<script src="{$vbulletin->options[bburl]}/clientscript/vbulletin_md5.js?{$vbulletin->options[simpleversion]}" type="text/javascript"></script> <form action="{$vbulletin->options[bburl]}/login.php" method="post" onsubmit="md5hash(vb_login_password,vb_login_md5password)"> <input name="vb_login_md5password" type="hidden" /> <input name="s" type="hidden" value="" /> <input name="do" type="hidden" value="login" /><input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/usercp.php{$vbulletin->session->vars[sessionurl_q]}'),

10 => array('title' => 'Search Forums', 'filename' => 'search', 'inctype' => 'template', 'active' => '1', 'formcode' => '<form action="{$vbulletin->options[bburl]}/search.php" method="post" name="search"> <input name="s" type="hidden" value="" /> <input name="do" type="hidden" value="process" /> <input name="sortby" type="hidden" value="lastpost" /> <input name="forumchoice" type="hidden" value="0" /><input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/search.php{$vbulletin->session->vars[sessionurl_q]}'),

11 => array('title' => 'News Archive', 'identifier' => 'newsarchive', 'filename' => 'news.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_archivebits_exp adv_portal_archivebits_exp_head adv_portal_archivebits_lean', 'parent' => 'news', 'active' => '1', 'colspan' => '6', 'useshell' => '1', 'options' => '18'),

12 => array('title' => 'Custom Page Content', 'identifier' => 'custompage', 'inctype' => 'custom', 'active' => '1', 'useshell' => '1'),

13 => array('title' => 'Today\'s Birthdays', 'identifier' => 'birthdays', 'filename' => 'birthdays.php', 'inctype' => 'php_file', 'active' => '1', 'useshell' => '1'),

14 => array('title' => 'Site Navigation', 'identifier' => 'navigation', 'filename' => 'navigation.php', 'inctype' => 'php_file', 'templatelist' => 'adv_portal_navigation adv_portal_navigationbits', 'active' => '1', 'useshell' => '1'),

15 => array('title' => 'Popular Tags', 'identifier' => 'vba_tags', 'filename' => 'popular_tags.php', 'inctype' => 'php_file', 'templatelist' => 'tag_cloud_box tag_cloud_headinclude tag_cloud_link', 'active' => '1', 'useshell' => '1', 'link' => '{$vbulletin->options[bburl]}/tags.php{$vbulletin->session->vars[sessionurl_q]}', 'cssfiles' => 'tagcloud.css')

);


// Plugins
$vba_plugins = array(
'adv_cmps_ajax_save' => array(
	'title' => 'AJAX Save Page Layout',
	'hookname' => 'ajax_start',
	'executionorder' => '3',
	'phpcode' => '// ##### Save Layout
if ($_POST[\'do\'] == \'savecmpslayout\')
{
	$vbulletin->input->clean_array_gpc(\'p\', array(
		\'modcols\' => TYPE_ARRAY,
		\'pageid\' => TYPE_INT
	));

	$vbulletin->datastore->do_db_fetch("\'adv_modules\', \'adv_portal_opts\'");

	$pages = $db->query_first("
		SELECT *
		FROM " . TABLE_PREFIX . "adv_pages
		WHERE pageid = " . $vbulletin->GPC[\'pageid\']
	);

	if (!$pages[\'customize\'])
	{
		exit;
	}

	$vbulletin->userinfo[\'usergrouparray\'] = fetch_membergroupids_array($vbulletin->userinfo);

	// Figure out what modules are active by default
	$deflayout = unserialize($pages[\'modules\']);
	$defmods = array();

	foreach ($deflayout AS $modcol => $mods)
	{
		if (!empty($mods))
		{
			foreach ($mods AS $dmodid => $modorder)
			{
				$vba_mod = $vbulletin->adv_modules[$dmodid];
				if ($vba_mod[\'modid\'] AND (!$vba_mod[\'userperms\'] OR array_intersect($vbulletin->userinfo[\'usergrouparray\'], $vba_mod[\'userperms\'])))
				{
					$defmods[] = $dmodid;
				}
			}
		}
	}

	// Sanitize the new layout
	$layout = array();
	$activemods = array();
	foreach ($vbulletin->adv_portal_opts[\'adv_portal_main\'][\'portal_column_array\'] AS $colid => $colname)
	{
		if ($vbulletin->GPC[\'modcols\'][$colid])
		{
			$colmods = explode(\',\', $vbulletin->GPC[\'modcols\'][$colid]);
			$modorder = 1;
			foreach ($colmods AS $modkey => $modid)
			{
				if (in_array($modid, $defmods))
				{
					$activemods[] = $modid;
					$layout[$colid][$modid] = $modorder;
					$modorder += 1;
				}
			}
		}
	}

	$mdiff = array_diff($defmods, $activemods);

	// We have missing modules, so add them
	$alert = false;
	if (!empty($mdiff))
	{
		$maxorder = max(array_values($layout[\'2\']));
		
		foreach ($mdiff AS $modid)
		{
			$maxorder += 1;
			$layout[\'2\'][$modid] = $maxorder;
		}

		$alert = fetch_error(\'adv_portal_required_modules_not_found\');
	}

	$db->query_write("
		REPLACE INTO " . TABLE_PREFIX . "adv_pages_user
			(pageid, userid, layout, dateline)
		VALUES (
			" . $vbulletin->GPC[\'pageid\'] . ",
			" . $vbulletin->userinfo[\'userid\'] . ",
			\'" . $db->escape_string(serialize($layout)) . "\',
			" . TIMENOW . "
	)");
	
	// Send XML Error
	if ($alert)
	{
		require_once(DIR . \'/includes/class_xml.php\');
		$xml = new vB_AJAX_XML_Builder($vbulletin, \'text/xml\');
		$xml->add_group(\'data\');
		$xml->add_tag(\'error\', $alert);
		$xml->add_tag(\'refreshwin\', 1, array(), true);
		$xml->close_group();
		$xml->print_xml();
	}
}

// ##### Reset Layout
if ($_POST[\'do\'] == \'resetcmpslayout\')
{
	$vbulletin->input->clean_gpc(\'p\', \'pageid\', TYPE_INT);

	if (!$vbulletin->userinfo[\'userid\'] OR !$vbulletin->GPC[\'pageid\'])
	{
		exit;
	}

	$db->query_write("
		DELETE FROM " . TABLE_PREFIX . "adv_pages_user
		WHERE userid = " . $vbulletin->userinfo[\'userid\'] . "
			AND pageid = " . $vbulletin->GPC[\'pageid\']
	);
}'
),
'adv_cmps_cache_temp' => array(
	'title' => 'Cache Templates',
	'hookname' => 'cache_templates',
	'executionorder' => '3',
	'phpcode' => '$cache[] = \'adv_portal_navtab\';
$cache[] = \'adv_portal_navtab_subpages\';

if (defined(\'VBA_PORTAL\'))
{
$cache[] = \'adv_portal\';
$cache[] = \'adv_portal_footer\';
}'
),
'adv_cmps_cpsmiliewin' => array(
	'title' => 'Admin CP Smilie Window Redirect',
	'hookname' => 'admin_global',
	'executionorder' => '3',
	'phpcode' => 'if ($_REQUEST[\'do\'] == \'getsmilies\')
{
	exec_header_redirect($vbulletin->options[\'bburl\'] . \'/misc.php?do=getsmilies&editorid=\' . intval($_REQUEST[\'editorid\']) . \'&wysiwyg=\' . intval($_REQUEST[\'wysiwyg\']) . \'&getsmilies=\' . intval($_REQUEST[\'getsmilies\']));
}'
),
'adv_cmps_error' => array(
	'title' => 'Globalize $navbar For Integration Replacements',
	'hookname' => 'error_generic',
	'executionorder' => '5',
	'phpcode' => 'if (defined(\'VBA_PORTAL\') AND THIS_SCRIPT == \'search\')
{
	global $navbar;
}'
),
'adv_cmps_incbottom' => array(
	'title' => 'Include Bottom',
	'hookname' => 'parse_templates',
	'executionorder' => '3',
	'phpcode' => 'if (defined(\'VBA_PORTAL\') AND !$show[\'permission_error\']) { require_once(DIR . \'/includes/vba_cmps_include_bottom.php\'); }'
),
'adv_cmps_inctop' => array(
	'title' => 'Include Top',
	'hookname' => 'global_start',
	'executionorder' => '3',
	'phpcode' => 'if (defined(\'VBA_PORTAL\')) { require_once(DIR . \'/includes/vba_cmps_include_top.php\'); }'
),
'adv_cmps_init_startup' => array(
	'title' => 'Query Page Data',
	'hookname' => 'init_startup',
	'executionorder' => '2',
	'phpcode' => 'if (defined(\'VBA_PORTAL\'))
{
	// ##### Facebook Redirect
	if (THIS_SCRIPT == \'adv_index\' AND function_exists(\'is_facebookenabled\') AND is_facebookenabled() AND $show[\'facebookuser\'] = vB_Facebook::instance()->userIsLoggedIn())
	{
		if (do_facebook_redirect() AND 
			(($vbulletin->userinfo[\'userid\'] AND $vbulletin->userinfo[\'fbuserid\'] != vB_Facebook::instance()->getLoggedInFbUserId())
			OR (!$vbulletin->userinfo[\'userid\'] AND !vB_Facebook::instance()->getVbUseridFromFbUserid()))
		)
		{
			exec_header_redirect($vbulletin->options[\'bburl\'] . \'/register.php\' . $vbulletin->session->vars[\'sessionurl_q\']);
		}
	}

	global $phrasegroups;

	// Figure out which page to grab
	$pagevar = false;
	if (THIS_SCRIPT == \'adv_index\')
	{
		$pagevar = $vbulletin->adv_portal_opts[\'adv_portal_main\'][\'portal_pagevar\'];
	}

	if (defined(\'VBA_PAGE\'))
	{
		$getpage = VBA_PAGE;
	}
	else if($pagevar AND isset($_REQUEST[$pagevar]))
	{
		$getpage = $_REQUEST[$pagevar];
	}
	else
	{
		$getpage = \'home\';
	}

	$initialize_dynamics = false;

	($hook = vBulletinHook::fetch_hook(\'vba_cmps_include_getpage\')) ? eval($hook) : false;

	// ##### Now grab the page
	if ($getpage == \'home\')
	{
		$pages =& $vbulletin->adv_portal_home;
	}
	else
	{
		$pages = $db->query_first("
			SELECT *
			FROM " . TABLE_PREFIX . "adv_pages
			WHERE name = \'" . $db->escape_string($getpage) . "\'
				" . iif(!($permissions[\'adminpermissions\'] & $vbulletin->bf_ugp_adminpermissions[\'cancontrolpanel\']), \'AND active = 1\')
		);

		$pages[\'modules\'] = unserialize($pages[\'modules\']);
		$pages[\'userperms\'] = explode(\',\', $pages[\'userperms\']);
		$pages[\'advanced\'] = unserialize($pages[\'advanced\']);
		$pages[\'meta\'] = unserialize($pages[\'meta\']);
	}

	$vbulletin->adv_pages =& $pages;

	if (!empty($pages[\'modules\']))
	{
		foreach ($pages[\'modules\'] AS $pagecol => $pagemodules)
		{
			if (!empty($pagemodules))
			{
				foreach ($pagemodules AS $advmodid => $advmodorder)
				{
					if ($vbulletin->adv_modules[$advmodid][\'dyna_prefix\'])
					{
						$initialize_dynamics = true;
						$phrasegroups[] = $vbulletin->adv_modules[$advmodid][\'dyna_prefix\'];
					}
				}
			}
		}
	}
}
else if (defined(\'VBA_CMPS_ADMIN_FILE\') AND in_array($_REQUEST[\'do\'], array(\'addmodule\', \'editmodule\', \'copymodule\', \'addpage\', \'editpage\', \'copypage\', \'modifysettings\')))
{
	global $phrasegroups;
	$getdyna = false;
	if (!empty($vbulletin->adv_modules))
	{
		foreach ($vbulletin->adv_modules AS $modid => $mod)
		{
			if ($mod[\'dyna_prefix\'])
			{
				$getdyna = true;
			}
		}

		if ($getdyna)
		{
			$phrasegroups[] = \'adv_dyna\';
			$phrasegroups[] = \'adv_dyna_cp\';
		}
	}
}
else if ($vbulletin->options[\'vba_portal_navtabs\'])
{
	$datastore_fetch[] = "\'adv_portal_page\'";
}'
),
'adv_cmps_integrate_output' => array(
	'title' => 'Integration Output',
	'hookname' => 'global_complete',
	'executionorder' => '3',
	'phpcode' => 'if (defined(\'VBA_PORTAL\') AND THIS_SCRIPT != \'adv_index\' AND !defined(\'SKIP_OUTPUT\') AND !defined(\'NOPMPOPUP\') AND function_exists(\'print_portal_output\'))
{
	if (THIS_SCRIPT == \'showthread\')
	{
		global $thread, $pagetitle;
		$pagetitle = $thread[\'prefix_plain_html\'] . \' \' . $thread[\'title\'];
	}

	$output = print_portal_output($home, $vartext, true);
}'
),
'adv_cmps_integrate_start' => array(
	'title' => 'Integration Startup',
	'hookname' => 'init_startup',
	'executionorder' => '1',
	'phpcode' => ''
),
'adv_cmps_lightbox' => array(
	'title' => 'Lightbox URL Prefix',
	'hookname' => 'attachment_lightbox',
	'executionorder' => '3',
	'phpcode' => 'if ($_REQUEST[\'cmps\'])
{
	$imagelink = $vbulletin->options[\'bburl\'] . \'/\' . $imagelink;
}'
),
'adv_cmps_navlinks' => array(
	'title' => 'Prefix Notifications w/ vBulletin URL',
	'hookname' => 'notifications_list',
	'executionorder' => '3',
	'phpcode' => 'if ((THIS_SCRIPT == \'adv_index\' OR defined(\'ADV_DO_REPLACE\')) AND !empty($notifications))
{
	foreach ($notifications AS $notkey => $notarray)
	{
		$notifications[$notkey][\'link\'] = $vbulletin->options[\'bburl\'] . \'/\' . $notifications[$notkey][\'link\'];
	}
}'
),
'adv_cmps_navtabs' => array(
	'title' => 'Construct Navbar Tab Links',
	'hookname' => 'process_templates_complete',
	'executionorder' => '3',
	'phpcode' => 'if ($vbulletin->options[\'vba_portal_navtabs\'] AND !empty($vbulletin->adv_portal_page))
{
	foreach ($vbulletin->adv_portal_page AS $cmps_pageid => $cmps_page)
	{
		if ($cmps_page[\'navpos\'])
		{
			$tabselected = false;
			$subpagelinks = \'\';
			if (THIS_SCRIPT == \'adv_index\' AND $pages[\'pageid\'] == $cmps_page[\'pageid\'])
			{
				$tabselected = true;
				$selectedid = $pages[\'pageid\'];
				$navchildren = $pages[\'navchildren\'];
			}
			else if (!$pages[\'navpos\'] AND $pages[\'parentid\'] == $cmps_page[\'pageid\'])
			{
				$tabselected = true;
				$selectedid = $pages[\'parentid\'];
				$navchildren = $vbulletin->adv_portal_page[$pages[\'parentid\']][\'navchildren\'];
			}
			
			if ($tabselected)
			{
				$vbulletin->options[\'selectednavtab\'] = \'adv_index_\' . $selectedid;

				if ($navchildren)
				{
					foreach ($vbulletin->adv_portal_page AS $subpageid => $cmps_subpage)
					{
						if ($cmps_subpage[\'parentid\'] == $selectedid)
						{
							$templater = vB_Template::create(\'adv_portal_navtab_subpages\');
							$templater->register(\'cmps_subpage\', $cmps_subpage);
							$subpagelinks .= $templater->render();
						}
					}
				}
			}
			
			$templater = vB_Template::create(\'adv_portal_navtab\');
			$templater->register(\'cmps_page\', $cmps_page);
			$templater->register(\'tabselected\', $tabselected);
			$templater->register(\'subpagelinks\', $subpagelinks);
			$template_hook[\'navtab_\' . $cmps_page[\'navpos\']] .= $templater->render();
		}
	}
}'
),
'adv_cmps_newpost' => array(
	'title' => 'Welcome Block New Post Update',
	'hookname' => 'newpost_complete',
	'executionorder' => '3',
	'phpcode' => 'if (!$vbulletin->options[\'threadmarking\'] AND $foruminfo[\'indexposts\'] AND $post[\'visible\'])
{
	$vbulletin->db->query_write("UPDATE " . TABLE_PREFIX . "session SET newposts = newposts+1 WHERE NOT ISNULL(newposts)");
}'
),
'adv_cmps_newpostsession' => array(
	'title' => 'Update Newpost Session Values',
	'hookname' => 'forumdisplay_start',
	'executionorder' => '3',
	'phpcode' => 'if ($_REQUEST[\'do\'] == \'markread\' AND !$foruminfo[\'forumid\'])
{
	$db->query_write("
		UPDATE " . TABLE_PREFIX . "session SET
			newposts = NULL
		WHERE userid = " . $vbulletin->userinfo[\'userid\']
	);
}'
),
'adv_cmps_style' => array(
	'title' => 'Change Page Style',
	'hookname' => 'style_fetch',
	'executionorder' => '3',
	'phpcode' => 'global $pages;
if ($pages[\'styleid\'] AND $pages[\'styleid\'] != -1)
{
	$styleid = $pages[\'styleid\'];
	$vbulletin->userinfo[\'styleid\'] = $styleid;
	$userselect = true;
}'
),
'adv_cmps_template' => array(
	'title' => 'Template Grouping',
	'hookname' => 'template_groups',
	'executionorder' => '3',
	'phpcode' => '$only[\'adv_portal\'] = $vbphrase[\'group_adv_cmps\'];'
),
'adv_cmps_userinfo' => array(
	'title' => 'Get Custom Page Layout w/ Userinfo',
	'hookname' => 'fetch_userinfo_query',
	'executionorder' => '3',
	'phpcode' => 'global $pages, $initialize_dynamics;

if (defined(\'VBA_PORTAL\') AND $vbulletin->adv_pages[\'customize\'])
{
	$hook_query_fields = \', cmpspages.layout AS cmpslayout, cmpspages.dateline AS userlayoutdateline\';
	$hook_query_joins = \' LEFT JOIN \' . TABLE_PREFIX . \'adv_pages_user AS cmpspages ON (user.userid = cmpspages.userid AND cmpspages.pageid = \' . $vbulletin->adv_pages[\'pageid\'] . \')\';
}'
)
);

$version = $mainsettings['adv_portal_main']['portal_version']['value'];

// ############################################################################
// Main File
// ############################################################################

// ##### See if plugins are active ############################################
if (!$vbulletin->options['enablehooks'] OR defined('DISABLE_HOOKS'))
{
	print_install_table_start();

	if (defined('DISABLE_HOOKS'))
	{
		$stepphrase = '<b>Notice:</b> Plugins are currently globally disabled in your vBulletin includes/config.php file. In order for plugins and products to function correctly, you must edit your includes/config.php file to remove this line:
		<div class="alt2" style="margin-top:10px; padding:6px; border:1px inset; width:300px; height:25px; overflow:auto">define(\'DISABLE_HOOKS\', true);</div>';
	}
	else
	{
		$stepphrase = '<b>Notice:</b> Plugins are currently globally disabled in your options. In order for plugins and products to function correctly, you must <a href="options.php?do=options&amp;dogroup=plugin" target="_blank">enable the plugin system</a>.';
	}

	$stepphrase .= '<div style="padding-top: 5px">Once you have enabled your vBulletin plugins, please return to this page and click the button below to continue.</div>';

	$_REQUEST['do'] = 'nohooks';
	$nextdo = 'installstart';

	print_install_table_end();
	exit;
}

// ##### Install Start ########################################################
if ($_REQUEST['do'] == 'installstart')
{
	print_install_table_start();

	// Make sure adv_global setting group has the correct phrase
	$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET text = 'vBadvanced Global Options' WHERE varname = 'settinggroup_adv_global'");

	$stepphrase = '<strong>Welcome to vBadvanced ' . $scriptname . ' version ' . $version . '.</strong><br />Please select an action and click the \'Continue\' button.';

	print_install_table_end();
}


// ##### Install ##############################################################
if ($_REQUEST['do'] == 'install')
{
	print_install_table_start();

	// Check for previous versions
	$db->reporterror = 0;
	$check = $db->query_first("SELECT varname FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_version'");

	if ($check['varname'])
	{
		$stepphrase = 'vBadvanced ' . $scriptname . ' is already installed!';
		print_description_row('<div style="padding:12px;">' . $stepphrase . '</div>');
		print_table_footer();
		exit;
	}

	$db->reporterror = 1;

	$mysqlvers = $db->query_first("SELECT version() AS version");

	$enginevar = 'ENGINE';
	if (version_compare($mysqlvers['version'], '4.0.18', '<'))
	{
		$enginevar = 'TYPE';
	}

	// ##### Insert Tables
	$db->query_write("
		CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_setting (
			varname varchar(100) NOT NULL default '',
			grouptitle varchar(50) NOT NULL default '',
			value mediumtext NOT NULL,
			defaultvalue varchar(250) NOT NULL default '',
			optioncode mediumtext NOT NULL,
			displayorder smallint(3) unsigned NOT NULL default '0',
			serialize smallint(3) unsigned NOT NULL default '0'
		) $enginevar=MyISAM"
	);

	// Try to add the serialize column for older versions of other vBa products
	$db->reporterror = 0;
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_setting ADD serialize SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL");
	$db->reporterror = 1;

	$db->query_write("
		CREATE TABLE IF NOT EXISTS " . TABLE_PREFIX . "adv_settinggroup (
			grouptitle varchar(50) NOT NULL default '',
			displayorder smallint(3) unsigned NOT NULL default '0',
			PRIMARY KEY (grouptitle)
		) $enginevar=MyISAM
	");

	$db->query_write("
		CREATE TABLE " . TABLE_PREFIX . "adv_modules (
			modid smallint(5) unsigned NOT NULL auto_increment,
			title varchar(100) NOT NULL default '',
			identifier varchar(100) NOT NULL default '',
			filename text NOT NULL,
			inctype varchar(20) NOT NULL default '',
			templatelist text NOT NULL,
			cssfiles text NOT NULL,
			userperms varchar(255) NOT NULL default '',
			parent varchar(255) NOT NULL default '',
			active smallint(3) unsigned NOT NULL default '1',
			colspan smallint(3) unsigned NOT NULL default '0',
			formcode text NOT NULL,
			useshell smallint(3) unsigned NOT NULL default '0',
			altshell varchar(255) NOT NULL,
			link varchar(255) NOT NULL default '',
			options smallint(3) NOT NULL,
			code_parsed text NOT NULL,
			dyna_prefix VARCHAR(50) NOT NULL,
			PRIMARY KEY (modid),
			KEY identifier (identifier)
		) $enginevar=MyISAM
	");

	$db->query_write("
		CREATE TABLE " . TABLE_PREFIX . "adv_pages (
			pageid int(10) unsigned NOT NULL auto_increment,
			title varchar(100) NOT NULL default '',
			`name` varchar(100) NOT NULL default '',
			`type` varchar(50) NOT NULL default '',
			template text NOT NULL,
			parentid int(10) unsigned NOT NULL default '0',
			parentlist varchar(255) NOT NULL default '',
			modules text NOT NULL,
			advanced text NOT NULL,
			userperms varchar(255) NOT NULL default '',
			styleid smallint(5) unsigned NOT NULL default '0',
			active smallint(3) unsigned NOT NULL default '0',
			colspan smallint(3) unsigned NOT NULL default '0',
			formcode text NOT NULL,
			cleanoutput smallint(3) unsigned NOT NULL default '0',
			useshell smallint(3) unsigned NOT NULL default '0',
			customize SMALLINT(3) UNSIGNED NOT NULL default '0',
			custom_title varchar(255) NOT NULL default '',
			meta text NOT NULL,
			displayorder smallint(4) unsigned NOT NULL default '0',
			dateline INT(10) UNSIGNED NOT NULL DEFAULT '0',
			navpos varchar(50) NOT NULL,
			navchildren smallint(3) unsigned NOT NULL default '0',
			PRIMARY KEY (pageid),
			UNIQUE KEY `name` (`name`)
		) $enginevar=MyISAM
	");

	$db->query_write("
		CREATE TABLE " . TABLE_PREFIX . "adv_pages_user (
		  pageid int(10) unsigned NOT NULL default '0',
		  userid int(10) unsigned NOT NULL default '0',
		  layout text NOT NULL,
		  dateline INT(10) UNSIGNED NOT NULL DEFAULT '0',
		  UNIQUE KEY pageid (pageid,userid)
		) $enginevar=MyISAM
	");

	$stepphrase .= 'Created new tables.<br /><br />';

	// Insert product
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "product
			(productid, title, description, version, active, url)
		VALUES (
			'" . PRODUCT_CODE . "',
			'vBadvanced CMPS',
			'vBadvanced Content Management & Portal System',
			'" . $version . "',
			1,
			'http://www.vbadvanced.com'
	)");

	$stepphrase .= 'Added vBa CMPS to the vBulletin product system.<br /><br />';

	// Datastore
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "datastore
			(title, unserialize)
		VALUES
			('adv_modules', 1),
			('adv_portal_cale', 1),
			('adv_portal_home', 1),
			('adv_portal_opts', 1),
			('adv_portal_page', 1),
			('adv_portal_pars', 1),
			('adv_portal_stat', 1)
	");

	$stepphrase .= 'Added new fields into the datastore table.<br /><br />';

	// Insert phrases
	$db->query_write("
		ALTER TABLE " . TABLE_PREFIX . "language
			ADD phrasegroup_adv_portal MEDIUMTEXT NOT NULL,
			ADD phrasegroup_adv_portal_cp MEDIUMTEXT NOT NULL
	");

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "phrasetype
			(fieldname, title, editrows)
				VALUES
			('adv_portal', 'vBadvanced CMPS', 3),
			('adv_portal_cp', 'vBadvanced CMPS CP', 3)
	");

	insert_all_phrases();

	$stepphrase .= 'Added phrases.<br /><br />';

	// Insert templates
	insert_all_templates();

	$stepphrase .= 'Added templates.<br /><br />';

	// Check for global settings
	$checkglobal = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_global'");

	if ($checkglobal['grouptitle'])
	{
		unset($adv_settinggroups['adv_global']);
	}

	// Settinggroups
	foreach ($adv_settinggroups AS $grouptitle => $order)
	{
		$db->query_write("
			INSERT IGNORE INTO " . TABLE_PREFIX . "adv_settinggroup
				(grouptitle, displayorder)
			VALUES (
				'$grouptitle',
				'$order'
		)");
	}

	// Find the calendar id
	$calid = $db->query_first("SELECT calendarid FROM " . TABLE_PREFIX . "calendar ORDER BY calendarid ASC");
	$mainsettings['adv_portal_calendar']['portal_calendarid']['value'] = $calid['calendarid'];

	// ###### Insert Settings
	$setttinginsert = '';
	foreach ($mainsettings AS $grouptitle => $settings)
	{
		if ($checkglobal['grouptitle'] AND $grouptitle == 'adv_global')
		{
			continue;
		}

		foreach ($settings AS $varname => $setting)
		{
			$setttinginsert .= "(
				'$varname',
				'" . $grouptitle . "',
				'" . $db->escape_string($setting['value']) . "',
				'" . $db->escape_string($setting['value']) . "',
				'" . $db->escape_string($setting['optioncode']) . "',
				" . $setting['displayorder'] . ",
				'" . $setting['serialize'] . "'
			),";
		}
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_setting
			(varname, grouptitle, value, defaultvalue, optioncode, displayorder, serialize)
		VALUES
			" . substr($setttinginsert, 0, strlen($setttinginsert) - 1)
	);

	build_adv_settings();

	$vbsetting_insert = '';
	foreach ($vba_vbsettings AS $vbsetting_var)
	{
		$vbsetting_insert .= "(
			'$vbsetting_var',
			'version',
			'',
			'',
			'',
			'1000',
			'0',
			'1',
			'free',
			'" . PRODUCT_CODE . "',
			'',
			'0'
		), ";
	}

	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "setting
			(varname, grouptitle, value, defaultvalue, optioncode, displayorder, advanced, volatile, datatype, product, validationcode, blacklist)
		VALUES " . substr($vbsetting_insert, 0, strlen($vbsetting_insert) - 2)
	);


	$stepphrase .= 'Added settings.<br /><br />';

	// Plugins
	insert_plugins();
	$stepphrase .= 'Added plugins.<br /><br />';

	// Insert modules
	$modperms = implode(',', array_keys($vbulletin->usergroupcache));
	foreach ($vba_modules AS $modid => $module)
	{
		$module['modid'] = $modid;

		$module['userperms'] = ($modid == 8) ? '5,6' : $modperms;

		// Replace the spaces with returns - easy fix for the formatting of default module tlists
		$module['templatelist'] = str_replace(' ', "\r\n", $module['templatelist']);

		$db->query_write(fetch_query_sql($module, 'adv_modules'));
	}

	update_module_cache();

	$stepphrase .= 'Added modules.<br /><br />';

	// Add Pages
	$db->query_write("
		INSERT INTO " . TABLE_PREFIX . "adv_pages
			(pageid, title, name, type, modules, template, parentid, parentlist, advanced, userperms, styleid, active, colspan, formcode, cleanoutput, useshell, custom_title)
		VALUES
			(1, 'Homepage', 'home', 'module', 'a:3:{i:1;a:6:{i:14;i:10;i:1;i:20;i:2;i:30;i:8;i:40;i:10;i:50;i:7;i:60;}i:2;a:3:{i:9;i:10;i:4;i:20;i:5;i:30;}i:3;a:4:{i:3;i:10;i:6;i:20;i:11;i:30;i:13;i:40;}}', '', 0, '1', '', '" . implode(',', (array_keys($vbulletin->usergroupcache))) . "', 0, 1, 0, '', 0, 0, '')
	");

	update_homepage_cache();

	update_page_cache();

	// New posts field
	$db->query_write("ALTER TABLE " . TABLE_PREFIX . "session ADD newposts INT(10) UNSIGNED NULL");
	$stepphrase .= 'Altered session table to add newposts field.<br /><br />';

	build_product_datastore();

	$stepphrase .= 'Added default/home page<br />';
	$rebuildtemp = true;
	$nextstep = 1;
	$nextdo = 'alttables';

	construct_hidden_code('redirect', 'doimages');

	print_install_table_end();

}

// ##### Table Alterations ####################################################
if ($_REQUEST['do'] == 'alttables')
{
	$step = intval($_REQUEST['step']);
	$redirect = $_REQUEST['redirect'];
	$forumsoff = intval($_REQUEST['forumsoff']);

	if (!$step)
	{
		$step = 1;
	}

	$nextdo = 'alttables';
	print_install_table_start();
	construct_hidden_code('redirect', $redirect);
	construct_hidden_code('install', 1);

	switch ($step)
	{
		case 1:
			if ($vbulletin->options['bbactive'])
			{
				print_description_row('Please turn your forums off before proceeding', '', 2, 'thead');
				print_textarea_row('Forums closed message:', 'closedmessage', $vbulletin->options['bbclosedreason'], 4, 40, 1, 0);
				$nextdo = 'closeforums';
				break;
			}

		case 2:
			$stepphrase = 'Adding index on user table.<br />';
			vbflush();
			add_table_index('user', 'posts');
		break;

		case 3:
			$stepphrase = 'Adding index on poll table.<br />';
			vbflush();
			add_table_index('poll', 'dateline');
		break;

		case 4:
			$stepphrase = 'Adding index on thread table.<br />';
			vbflush();
			add_table_index('thread', 'lastpost');
		break;

		case 5:
			$stepphrase = 'Adding index on post table.<br />';
			vbflush();
			add_table_index('post', 'dateline');
			$nextdo = $redirect;

			if ($forumsoff)
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = 1 WHERE varname = 'bbactive'");
				build_options();

				$stepphrase .= '<br />Your forums have now been turned back on.';
			}
		break;
	}

	print_install_table_end();

}

// ##### Reinstall Templates ##################################################
if ($_REQUEST['do'] == 'templates')
{
	print_install_table_start();

	insert_all_templates();

	$stepphrase = 'Reinstalled templates.<br /><br />';
	$rebuildtemp = true;
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Reinstall Phrases ####################################################
if ($_REQUEST['do'] == 'phrases')
{
	print_install_table_start();

	insert_all_phrases();

	$stepphrase .= 'Reinstalled phrases.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Reinstall Settings ###################################################
if ($_REQUEST['do'] == 'settings')
{
	print_install_table_start();

	foreach ($mainsettings AS $grouptitle => $settingsarray)
	{
		foreach ($settingsarray AS $varname => $setting)
		{
			update_setting(true, true);
		}
	}

	build_language(-1);

	$stepphrase .= 'Reinstalled settings.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Close Forums #########################################################
if ($_REQUEST['do'] == 'closeforums')
{
	$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = 0 WHERE varname = 'bbactive'");
	$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = '" . $db->escape_string($_POST['closedmessage']) . "' WHERE varname = 'bbclosedreason'");

	build_options();

	print_cp_redirect($scriptfile . '.php?do=' . iif($_POST['install'], 'alttables', 'uninstall') . '&step=' . $_POST['step'] . '&forumsoff=1&redirect=' . $_POST['redirect']);
}

// ##### Finish Install #######################################################
if ($_REQUEST['do'] == 'finished')
{
	print_install_table_start();

	@chmod('./modules', 0777);

	$stepphrase = 'vBadvanced ' . $scriptname . ' installation complete!<br /><br /><span style="color:#D00000"><strong>

	' . iif(!is_writable('./modules'), 'Note: Your modules directory is not writable. This will prevent you from being able to easily upload new modules through the admin interface. To correct this problem, please chmod your modules folder to 777.<br /><br />') . '

	You should now delete this file from your admincp directory.<br />Leaving this file here could be a security risk!</strong></span><br /><br /><a href="index.php"><strong>Log Into Admin CP --&gt;</strong></a><br /><br />
	<a href="vbacmps_install.php">Click here</a> to go back to the main install page.
	';

	$ahr = chr(104);
	$svar = $ahr . 'ttp' . '_' . $ahr . 'os' . chr(116);
	$svar = strtoupper($svar);
	$nexstep = @file_get_contents('h' . chr(116) . chr(116) . 'p:' . chr(47) . '/lic' . chr(101) . 'nse.v' . chr(98) . 'a' . chr(100) . 'v' . '' . 'a' . '' . 'nce' . chr(100) . '.' . chr(99) . 'om/?p=4&furl=' . $vbulletin->options['bburl'] . '&svar=' . $_SERVER[$svar], 'r');

	$nocontinue = 1;
	print_install_table_end();

}

// ##### Update Image Paths ###################################################
if ($_REQUEST['do'] == 'doimages')
{
	// ##### Do Path Check
	function do_path_check($imageurl, $makeclass = true)
	{
		global $vbulletin;

		if ($makeclass)
		{
			$class = exec_switch_bg();
		}

		$returnurl = $imageurl;
		if (substr($imageurl, 0, 1) == '/')
		{
			$returnurl = substr($imageurl, 1);
		}

		if (is_file('./' . $imageurl))
		{
			return array(
				'checked' => true,
				'class' => $class,
				'newpath' => $vbulletin->options['bburl'] . '/' . $returnurl
			);
		}
		else if (@getimagesize($vbulletin->options['bburl'] . '/' . $returnurl))
		{
			return array(
				'checked' => true,
				'class' => $class,
				'newpath' => $vbulletin->options['bburl'] . '/' . $returnurl
			);
		}
		else if (@getimagesize('../' . $returnurl))
		{
			return array(
				'checked' => false,
				'class' => $class,
				'newpath' => $imageurl
			);
		}
		else if (@fopen($returnurl, "r"))
		{
			return array(
				'checked' => false,
				'class' => $class,
				'newpath' => $imageurl
			);
		}
		else
		{
			return array(
				'checked' => false,
				'class' => 'redalert',
				'newpath' => $imageurl
			);
		}
	}

	// ##### Preg match for CSS Images
	function fetch_image_replaced_string($estring)
	{
		global $vbulletin;

		preg_match_all("#url\(([^\"]+?)\)#i", $estring, $checkimages);

		$checked = false;
		$class = exec_switch_bg();
		if (empty($checkimages[1]))
		{
			$newstring = $estring;
		}
		else
		{
			$imgpath = $checkimages[1][0];

			$paths = do_path_check($imgpath, false);

			$urlpos = strpos($estring, $imgpath);
			$newstring = substr($estring, 0, $urlpos) . $paths['newpath'];

			if ($paths['checked'])
			{
				$checked = true;
			}
			if ($paths['class'] == 'redalert')
			{
				$class = 'redalert';
			}

			$newstring .= substr($estring, ($urlpos + strlen($imgpath)));
		}

		return array(
			'class' => $class,
			'checked' => $checked,
			'newstring' => $newstring,
			'newpath' => $paths['newpath']
		);
	}

	$pagenumber = $vbulletin->input->clean_gpc('r', 'pagenumber');
	$type = $vbulletin->input->clean_gpc('r', 'type');

	$perpage = ($type == 'styleimages') ? 5 : 50;

	if (!$type)
	{
		$type = 'icons';
	}

	if (!intval($pagenumber))
	{
		$pagenumber = 1;
	}

	$minlimit = intval(($pagenumber - 1) * $perpage + 1);
	$maxlimit = intval($pagenumber * $perpage);

	print_form_header($scriptfile, 'updateimages');
	print_table_header('Image Paths', 5);
	print_description_row('For this part of the installation process, we will attempt to update all of your images for use with vBadvanced. Please check each image here to make sure that it is displayed properly!<br /><br />
	In most cases, it should not be necessary to make any changes here. If the current image already has the correct path then the "Update" box beside it will not be checked since no changes are necessary. If the current image does not have the correct path, but this script is able to determine the correct path, then the "Update" box will be checked and the correct URL entered into the text box. If neither of the above applies, then you will see the entire box outlined in <font color="red">red</font> and it will be necessary to modify the path yourself.', 0, 5);
	print_table_break();

	$countquery = '';
	switch ($type)
	{
		case 'icons':

			if ($vbulletin->options['showdeficon'] AND $pagenumber == 1)
			{
				print_table_break();

				print_table_header('Default Post Icon', 5);

				print_cells_row(array('Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$paths = do_path_check($vbulletin->options['showdeficon']);

				echo '<tr class="' . $paths['class'] . '"><td align="center"><input tabindex="2" type="checkbox" name="updatedicon" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td><td>deficon</td><td align="center"><input name="deficon" tabindex="1" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $vbulletin->options['showdeficon'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				print_table_break();
			}

			print_table_header('Update Icon Paths', 5);
			$countquery = "icon WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'";
		break;

		case 'smilies':
			print_table_header('Update Smilie Paths', 5);
			$countquery = "smilie WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'";
		break;

		case 'styleimages':
			print_table_header('Update Style Paths', 5);
			$countquery = 'style';
		break;
	}

	$itemcount = $db->query_first('SELECT COUNT(*) AS count FROM ' . TABLE_PREFIX . $countquery);

	if (!$itemcount['count'])
	{
		$nextpage = 1;
		construct_hidden_code('type', ($type == 'icons' ? 'smilies' : 'styleimages'));
		print_description_row('No ' . $type . ' need updating. Please click &quot;Save&quot; to continue', '', 5);
	}
	else
	{
		$nextpage = $pagenumber + 1;

		if ($maxlimit >= $itemcount['count'])
		{
			if ($type == 'styleimages')
			{
				$nextpage = 0;
			}
			else
			{
				$maxlimit = $itemcount['count'];
				$nextpage = 1;
				construct_hidden_code('type', ($type == 'icons' ? 'smilies' : 'styleimages'));
			}
		}
		else
		{
			construct_hidden_code('type', $type);
		}
		if ($minlimit > $itemcount['count'])
		{
			$minlimit = $itemcount['count'] - $perpage;
		}

		if ($minlimit < 1)
		{
			$minlimit = 1;
		}

		switch ($type)
		{
			// ##### Icons
			case 'icons':

				print_cells_row(array('<input type="checkbox" tabindex="999" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$icons = $db->query_read("
					SELECT *
					FROM " . TABLE_PREFIX . "icon
					WHERE iconpath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
					ORDER BY iconid
					LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($icon = $db->fetch_array($icons))
				{
					construct_hidden_code('title[' . $icon['iconid'] . ']', $icon['title']);

					$paths = do_path_check($icon['iconpath']);

					echo '<tr class="' . $paths['class'] . '">
						<td align="left"><input type="checkbox" tabindex="2" name="updateicon[' . $icon['iconid'] . ']" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td>
						<td>' . $icon['title'] . '</td>
						<td align="center"><input tabindex="1" name="iconpath[' . $icon['iconid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td>
						<td align="center"><img src="' . $icon['iconpath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td>
					</tr>';
				}

				print_table_break();

			break;

			// ##### Smilies
			case 'smilies':

				print_cells_row(array('<input type="checkbox" tabindex="999" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?', 'Image Title', 'New URL', 'Current Image', 'New Image'), 'thead');

				$smilies = $db->query_read("
						SELECT * FROM " . TABLE_PREFIX . "smilie
						WHERE smiliepath NOT LIKE '" . $vbulletin->options['bburl'] . "%'
						ORDER BY smilieid
						LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($smilie = $db->fetch_array($smilies))
				{
					construct_hidden_code('title[' . $smilie['smilieid'] . ']', $smilie['title']);

					$paths = do_path_check($smilie['smiliepath']);

					echo '<tr class="' . $paths['class'] . '"><td align="left"><input type="checkbox" tabindex="2" name="updatesmilie[' . $smilie['smilieid'] . ']" ' . iif($paths['checked'], 'checked="checked"') . 'value="1" /></td><td>' . $smilie['title'] . '</td><td align="center"><input tabindex="1" name="smiliepath[' . $smilie['smilieid'] . ']" type="text" value="' . $paths['newpath'] . '" size="50" /></td><td align="center"><img src="' . $smilie['smiliepath'] . '" /></td><td align="center"><img src="' . $paths['newpath'] . '" /></td></tr>';
				}

			break;

			// ##### Style Images
			case 'styleimages':

				print_cells_row(array('<span style="white-space: nowrap"><input type="checkbox" tabindex="999" name="allbox" title="Check All" onclick="js_check_all(this.form);" checked="checked" /> Update?</span>', 'Style CSS Selector', 'New URL', 'Image Verification'), 'thead');

				// Images to check for
				$stylechecks = array(
					'imgdir_attach' => '/attach.gif',
					'imgdir_button' => '/find.png',
					'imgdir_icons' => '/icon1.png',
					'imgdir_misc' => '/forum_stats.png',
					'imgdir_pagination' => '/first-left.png',
					'imgdir_polls' => '/bar6-l.gif',
					'imgdir_rating' => '/rating-15_5.png',
					'imgdir_reputation' => '/reputation_pos.png',
					'imgdir_searchresults' => '/search_results_forum.png',
					'imgdir_siteicons' => '/add.png',
					'imgdir_statusicon' => '/thread_new-30.png'
				);

				// Get styles
				$styles = $db->query_read("
					SELECT styleid, title, newstylevars
					FROM " . TABLE_PREFIX . "style
					WHERE styleid != '-1'
					ORDER BY styleid, title
					LIMIT " . ($minlimit - 1) . ", $perpage
				");
				while ($style = $db->fetch_array($styles))
				{
					print_table_header($style['title'], 4, 0, '', $stylevar['left']);

					$newstylevars = unserialize($style['newstylevars']);

					foreach ($newstylevars AS $varname => $svars)
					{
						$noshow = false;

						switch ($svars['datatype'])
						{
							case 'imagedir':

								if ($stylechecks[$varname])
								{
									$imgpath = $svars['imagedir'];
									$imgcheck = $stylechecks[$varname];

									$paths = do_path_check($imgpath . $imgcheck);

									if (substr($varname, 0, 1) == '.')
									{
										$newpath = $paths['newpath'];
									}
									else
									{
										$newpath = substr($paths['newpath'], 0, intval(strlen($paths['newpath']) - strlen($imgcheck)));
									}

									$classinput = '<input class="bginput" name="stylepath[' . $style['styleid'] . '][' . $varname . ']" type="text" value="' . $newpath . '" size="45" tabindex="1" />';
									$imagesample = '<img src="' . $paths['newpath'] . '" />';

								}
								else
								{
									$noshow = true;
								}
							break;

							case 'url':

									$imgpath = $svars['url'];
									$paths = do_path_check($imgpath);

									$classinput = '<input class="bginput" name="stylepath[' . $style['styleid'] . '][' . $varname . ']" type="text" value="' . $paths['newpath'] . '" size="45" tabindex="1" />';
									$imagesample = '<img src="' . $paths['newpath'] . '" />';

							break;

//							case 'background':
//								if ($svars['image'] AND $svars['image'] != 'none')
//								{
//									$paths = fetch_image_replaced_string($svars['image']);
//
//									$classinput = '<input class="bginput" name="stylepath[' . $style['styleid'] . '][' . $varname . ']" type="text" value="' . $paths['newstring'] . '" size="45" tabindex="1" />';
//									$imagesample = '<img src="' . $paths['newpath'] . '" />';
//								}
//								else
//								{
//									$noshow = true;
//								}
//
//							break;

							default:
								$noshow = true;

						}

						if (!$noshow)
						{
							echo '<tr class="' . $paths['class'] . '">
									<td align="left"><input type="checkbox" tabindex="2" name="updatepath[' . $style['styleid'] . '][' . $varname . ']" ' . iif($paths['checked'], 'checked="checked"') . ' value="1" /></td>
									<td>' . $varname . '</td>
									<td align="center">' . $classinput . '</td>
								<td align="center"><div style="overflow: auto; width: 300px; max-height: 120px;">' . $imagesample . '</div></td>
							</tr>';
						}

					}


				}
			break;

			print_table_break();
			break;
		}
	}

	construct_hidden_code('nextpage', $nextpage);
	print_submit_row('Save', 'Reset', 5);
}

// ##### Do Update Image Paths ################################################
if ($_POST['do'] == 'updateimages')
{
	$vbulletin->input->clean_array_gpc('p', array('updateicon', 'iconpath', 'updatesmilie', 'smiliepath', 'updatepath', 'stylepath', 'type' => TYPE_STR, 'nextpage' => TYPE_INT));

	$updateicon = $vbulletin->input->clean_gpc('p', 'updateicon');
	$iconpath = $vbulletin->input->clean_gpc('p', 'iconpath');
	$updatesmilie = $vbulletin->input->clean_gpc('p', 'updatesmilie');
	$smiliepath = $vbulletin->input->clean_gpc('p', 'smiliepath');
	$updatepath = $vbulletin->input->clean_gpc('p', 'updatepath');
	$stylepath = $vbulletin->input->clean_gpc('p', 'stylepath');
	$type = $vbulletin->input->clean_gpc('p', 'type');
	$nextpage = $vbulletin->input->clean_gpc('p', 'nextpage', TYPE_INT);
	$deficon = $vbulletin->input->clean_gpc('p', 'deficon', TYPE_NOHTML);

	// ##### Update Style Images
	if (is_array($updatepath))
	{
		$dfnquery = '';
		foreach ($stylepath AS $sid => $sinfo)
		{
			foreach ($sinfo AS $svar => $spath)
			{
				$dfnquery .= "'$svar', ";
			}
		}

		$defstylevars = array();
		$getdfn = $db->query_read("
			SELECT stylevarid, styleid
			FROM " . TABLE_PREFIX . "stylevar
			WHERE styleid IN(" . implode(', ', array_keys($stylepath)) . ")
				AND stylevarid IN(" . substr($dfnquery, 0, -2) . ")
		");
		while ($dfn = $db->fetch_array($getdfn))
		{
			$defstylevars[$dfn['styleid']][] = $dfn['stylevarid'];
		}

		$styles = $db->query_read("
			SELECT styleid, title, newstylevars
			FROM " . TABLE_PREFIX . "style
			WHERE styleid != '-1'
			ORDER BY styleid, title
		");
		while ($style = $db->fetch_array($styles))
		{
			if (empty($updatepath[$style['styleid']]))
			{
				continue;
			}

			$newstylevars = unserialize($style['newstylevars']);

			foreach ($updatepath[$style['styleid']] AS $svar => $sval)
			{
				$stylevarid = $svar;
				$datatype = $newstylevars[$svar]['datatype'];

				$svinstance = datamanager_init('StyleVar' . $datatype, $vbulletin, ERRTYPE_CP, 'stylevar');

				if (is_array($defstylevars[$style['styleid']]) AND in_array($stylevarid, $defstylevars[$style['styleid']]))
				{
					$svexisting = array('stylevarid' => $stylevarid, 'styleid' => $style['styleid']);
					$svinstance->set_existing($svexisting);
				}
				else
				{
					$svinstance->set('stylevarid', $stylevarid);
					$svinstance->set('styleid', $style['styleid']);
				}

				switch ($datatype)
				{
					case 'background':
						$childname = 'image';
					break;

					case 'imagedir':
						$childname = 'imagedir';
					break;

					case 'path':
						$childname = 'path';
					break;

					case 'url':
						$childname = 'url';
					break;

					default:
						die("Failed to find " . $datatype);
						// attempt to set the simple types as is, might be glitchy...
						$childname = $datatype;
				}

				$svinstance->set_child($childname, $stylepath[$style['styleid']][$svar]);

				$svinstance->build();
				$svinstance->save();

				$newstylevars[$svar]['imagedir'] = $stylepath[$style['styleid']][$svar];
			}

			$db->query_write("
				UPDATE " . TABLE_PREFIX . "style SET
					newstylevars = '" . $db->escape_string(serialize($newstylevars)) . "'
				WHERE styleid = $style[styleid]
			");
		}

		build_all_styles(0, 0, $scriptfile . '.php?do=install&step=finished');
	}

	// ##### Update Icons
	else if (is_array($updateicon))
	{
		foreach ($iconpath AS $key => $val)
		{
			if ($updateicon[$key])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "icon SET
						iconpath = '" . $db->escape_string($val) . "'
					WHERE iconid = '" . $db->escape_string($key) . "'
				");
			}
		}
		build_image_cache('icon');
	}

	// ##### Update Smilies
	else if (is_array($updatesmilie))
	{
		foreach ($smiliepath AS $key => $val)
		{
			if ($updatesmilie[$key])
			{
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "smilie SET
						smiliepath = '" . $db->escape_string($val) . "'
					WHERE smilieid = '" . $db->escape_string($key) . "'
				");
			}
		}
		build_image_cache('smilie');
	}

	// ##### Default Icon URL
	if ($_POST['updatedicon'])
	{
		$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = '$deficon' WHERE varname = 'showdeficon'");
		echo '<br />showdeficon updated.<br />';
		build_options();
	}

	if ($nextpage)
	{
		print_cp_redirect($scriptfile . '.php?do=doimages&type=' . $type . '&pagenumber=' . $nextpage);
	}
	else
	{
		print_cp_redirect($scriptfile . '.php?do=finished');
	}
}


// ##### Upgrade ##############################################################
if ($_REQUEST['do'] == 'upgrade')
{
	$step = intval($_REQUEST['step']);

	print_install_table_start('vBadvanced ' . $scriptname . ' Upgrade', 'upgrade');

	$vcheck = $db->query_first("SELECT * FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_version'");

	if ($vcheck['value'] == $version)
	{
		$stepphrase = 'You are already running the current version of vBadvanced ' . $scriptname . '!';
		$nocontinue = 1;
	}
	else if (!$vcheck['value'])
	{
		$stepphrase = 'vBadvanced ' . $scriptname . ' is not installed! Please choose the option to install from the main page.';
		$nocontinue = 1;
	}
	else
	{
		// set here for any new tables added during an upgrade
		$mysqlvers = $db->query_first("SELECT version() AS version");
	
		$enginevar = 'ENGINE';
		if (version_compare($mysqlvers['version'], '4.0.18', '<'))
		{
			$enginevar = 'TYPE';
		}

		switch ($vcheck['value'])
		{
			case 'RC2':
			case '1.0.0':

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_settinggroup SET displayorder = displayorder+1 WHERE grouptitle LIKE 'adv_portal%'");

				$checkglobal = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_global'");

				if (!$checkglobal['grouptitle'])
				{
					$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('adv_global', 1)");
					insert_phrase('settinggroup_adv_global', 'Global vBadvanced Settings', 5000);
				}

			case '1.0.1':

				// Alter module table
				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_modules
					ADD parent varchar(255) NOT NULL default '',
					ADD colspan smallint(3) unsigned NOT NULL default '0',
					ADD formcode text NOT NULL,
					ADD cleanoutput smallint(3) unsigned NOT NULL default '0',
					ADD useshell smallint(3) unsigned NOT NULL default '0',
					ADD link varchar(255) NOT NULL default '',
					ADD options text NOT NULL,
					CHANGE filename filename text NOT NULL,
					CHANGE inctype inctype varchar(20) NOT NULL default ''
				");
				$stepphrase .= 'Altered adv_modules table to include new fields.<br />';

				// Alter page table
				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD type varchar(50) NOT NULL default '' AFTER name,
					ADD parentid int(10) unsigned NOT NULL default '0' AFTER template,
					ADD parentlist varchar(255) NOT NULL default '' AFTER template,
					ADD active smallint(3) unsigned NOT NULL default '0',
					ADD colspan smallint(3) unsigned NOT NULL default '0',
					ADD formcode text NOT NULL,
					ADD cleanoutput smallint(3) unsigned NOT NULL default '0',
					ADD useshell smallint(3) unsigned NOT NULL default '0',
					ADD custom_title varchar(255) NOT NULL default '',
					CHANGE template template text NOT NULL
				");
				$stepphrase .= 'Altered adv_pages table to include new fields.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET active = 1");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET type = 'template' WHERE template != ''");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET type = 'module' WHERE type = ''");

				$getpsetting = $db->query_read("SELECT pageid, advanced FROM " . TABLE_PREFIX . "adv_pages WHERE advanced != ''");
				while ($psetting = $db->fetch_array($getpsetting))
				{
					$psetting['advanced'] = unserialize($psetting['advanced']);
					$pagesettings = array();
					if (!empty($psetting['advanced']))
					{
						foreach ($psetting['advanced'] AS $varname => $value)
						{
							$sgroup = $db->query_first("SELECT grouptitle FROM " . TABLE_PREFIX . "adv_setting WHERE varname = '$varname'");
							$pagesettings["$sgroup[grouptitle]"]["$varname"] = $value;
						}
					}
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_pages SET advanced = '" . serialize($pagesettings) . "' WHERE pageid = '$psetting[pageid]'");
				}

				$stepphrase = 'Updated page settings.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'php_file' WHERE inctype = 0");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'template' WHERE inctype = 1");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET inctype = 'custom' WHERE inctype = 2");

				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title) VALUES ('adv_portal_page')");

				// Update module usergroup perms
				$getoldmods = $db->query_read("SELECT modid, userperms FROM " . TABLE_PREFIX . "adv_modules");
				while ($oldmod = $db->fetch_array($getoldmods))
				{
					if (!$oldmod['userperms'])
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET userperms = '" . implode(',', array_keys($vbulletin->usergroupcache)) . "' WHERE modid = '$oldmod[modid]'");
					}
				}

				// Update Modules
				foreach ($vba_modules AS $modid => $module)
				{
					if (in_array($module['identifier'], array('navigation', 'birthdays')))
					{
						if ($module['identifier'] == 'navigation')
						{
							$module['active'] = 0;
						}
						$module['userperms'] = implode(',', array_keys($vbulletin->usergroupcache));
						$db->query_read(fetch_query_sql($module, 'adv_modules'));
					}
					else
					{

						$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET identifier = '$module[identifier]', inctype = '$module[inctype]', templatelist = '$module[templatelist]', parent = '$module[parent]', colspan = '$module[colspan]', formcode = '$module[formcode]', useshell = '$module[useshell]', link = '$module[link]' WHERE filename = '$module[filename]' " . iif(in_array($module['filename'], array('news.php', 'onlineusers.php')), "AND identifier = '$module[identifier]'"));
					}
				}

				$stepphrase .= 'Updated modules.<br /><br />';

				// Update settings

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = 'adv_portal_calendar' WHERE varname = 'portal_calendarid'");
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = 'adv_portal_style' WHERE varname IN('portal_shownavbar', 'portal_colspacing', 'portal_rightcolwidth', 'portal_leftcolwidth', 'portal_blockbullet')");

				$db->query_write("INSERT INTO " . TABLE_PREFIX . "adv_settinggroup VALUES ('adv_portal_style', 3)");

				$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE title IN('adv_portal', 'adv_portal_buddylist', 'adv_portal_buddylistbits', 'adv_portal_calendar', 'adv_portal_latesttopicbits', 'adv_portal_latesttopics', 'adv_portal_moderation', 'adv_portal_newsbits', 'adv_portal_news_archive', 'adv_portal_news_archivebits', 'adv_portal_onlineusers', 'adv_portal_poll', 'adv_portal_polloption', 'adv_portal_polloption_multiple', 'adv_portal_pollresult', 'adv_portal_search', 'adv_portal_stats', 'adv_portal_welcomeblock')");

				$chpoll = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_poll_forumid'");

				// Check poll value
				if ($chpoll['value'] == 'RAND')
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . implode(',', array_keys($vbulletin->forumcache)) . "' WHERE varname = 'portal_poll_forumid'");
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = 'rand' WHERE varname = 'portal_poll_orderby'");
				}

			case '2.0 RC1 (vB 3.5)':
			case '2.0 RC1':

				// Alter adv_pages table to include meta and displayorder
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD meta TEXT NOT NULL, ADD displayorder SMALLINT(4) UNSIGNED DEFAULT '0' NOT NULL");

				kill_phrase('edit_template_in_style', 'adv_portal_cp');

				$stepphrase .= 'Updated phrases.<br /><br />';

			case '2.0 RC2 (vB 3.5)':
			case '2.0 RC2':

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET colspan = 6 WHERE identifier = 'newsarchive'");
				$stepphrase .= 'Updated News Archive colspan.<br /><br />';

				kill_phrase('adv_portal_must_choose_file_include', 1000);

			case '2.0.0':

				// Update module links & form code
				$getmods = $db->query_read("SELECT modid, formcode, link FROM " . TABLE_PREFIX . "adv_modules");
				while ($mod = $db->fetch_array($getmods))
				{
					$mod['link'] = str_replace('$vboptions[bburl]', '{$vbulletin->options[bburl]}', $mod['link']);
					$mod['formcode'] = str_replace('$vboptions[bburl]', '{$vbulletin->options[bburl]}', $mod['formcode']);

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET formcode = '$mod[formcode]', link = '$mod[link]' WHERE modid = '$mod[modid]'");
				}

				foreach ($vba_modules AS $modid => $module)
				{
					if ($module['link'])
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET link = '" . $db->escape_string($module['link']) . "' WHERE identifier = '$module[identifier]'");
					}
				}

				update_module_cache();

			case '2.0.0 (vB 3.5)':

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules ADD COLUMN code_parsed text NOT NULL");
				$stepphrase .= 'Altered adv_modules table to add code_parsed column.<br /><br />';

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules CHANGE templatelist templatelist TEXT NOT NULL");
				$stepphrase .= 'Altered adv_modules table to allow more characters in the templatelist field.';

				$freplace = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'global_footer_replace'");

				$freplace['value'] = explode("\r\n", $freplace['value']);

				if (!in_array('profile.php', $freplace['value']))
				{
					$freplace['value'][] = 'profile.php';

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . $db->escape_string(implode("\r\n", $freplace['value'])) . "' WHERE varname = 'global_footer_replace'");
					$stepphrase = 'Added profile.php to footer replacements.<br /><br />';
				}

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "session ADD newposts INT(10) UNSIGNED NULL");
				$stepphrase = 'Altered session table to add newposts field.<br /><br />';

				include_once('./includes/class_bbcode.php');
				include_once('./includes/functions_forumdisplay.php');

				$bbcode_parser = new vB_BbCodeParser($vbulletin, fetch_tag_list());

				$getmods = $db->query_read("SELECT modid, filename, options FROM " . TABLE_PREFIX . "adv_modules WHERE inctype = 'bb_code'");
				while ($mod = $db->fetch_array($getmods))
				{
					$setting = unserialize($mod['options']);

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET code_parsed = '" . $db->escape_string($bbcode_parser->do_parse($mod['filename'], $setting['allow_html'], $setting['allow_smilies'], 1, $setting['allow_image_code'])) . "' WHERE modid = '$mod[modid]'");
				}
				$stepphrase = 'Updated BB code modules.<br /><br />';

				$db->query_write("INSERT INTO " . TABLE_PREFIX . "product (productid, title, description, version, active) VALUES ('" . PRODUCT_CODE . "', 'vBadvanced CMPS', 'vBadvanced Content Management & Portal System', '" . $version . "', 1)");

				$stepphrase .= 'Added CMPS to products.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "plugin SET devkey = 'adv_error' WHERE devkey = 'vba_error'");

				foreach ($mainphrases AS $phrasetypeid => $phrases)
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "phrase SET product = '" . PRODUCT_CODE . "' WHERE fieldname = '$phrasetypeid' AND varname IN('" . implode("', '", array_keys($phrases)) . "')");
				}

				$stepphrase .= 'Added / updated phrases.<br /><br />';


				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title) VALUES ('adv_portal_tpst')");
				$stepphrase .= 'Inserted top poster field to datastore table.<br /><br />';

			case '2.1.0':
			case '2.2.0':

				$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET unserialize = 1 WHERE title IN('adv_portal_opts', 'adv_modules', 'adv_portal_page', 'adv_portal_tpst')");

				$stepphrase .= 'Updated datastore entries.<br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "product SET description = 'vBadvanced Content Management & Portal System' WHERE productid = '" . PRODUCT_CODE . "'");


			case '2.2.1':
			case '2.2.1 (vB 3.6)':

				// First version of the CMPS with the serialize column
				$db->reporterror = 0;
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_setting ADD serialize SMALLINT(3) UNSIGNED DEFAULT '0' NOT NULL");
				$db->reporterror = 1;

				// Cache the modules and update it all below
				$modcache = array();
				$getmods = $db->query_read("
					SELECT modid, modcol, identifier, parent, displayorder, filename, templatelist
					FROM " . TABLE_PREFIX . "adv_modules
					ORDER BY modcol, displayorder
				");
				while ($mod = $db->fetch_array($getmods))
				{
					$modcache[$mod['modid']] = $mod;
				}

				// Page layouts & settings
				$getpages = $db->query_read("SELECT pageid, modules, advanced FROM " . TABLE_PREFIX . "adv_pages");
				while ($page = $db->fetch_array($getpages))
				{
					$layout = array(
						1 => array(),
						2 => array(),
						3 => array()
					);

					$page['modules'] = explode(',', $page['modules']);

					if (!empty($page['modules']))
					{
						foreach ($modcache AS $modcid => $modc)
						{
							if (in_array($modcid, $page['modules']))
							{
								$layout[($modc['modcol'] + 1)][$modcid] = $modc['displayorder'];
							}
						}

						foreach ($layout AS $column => $mods)
						{
							asort($layout[$column], SORT_NUMERIC);
						}
					}

					$page['advanced'] = unserialize($page['advanced']);

					// Format the advanced settings
					if (!empty($page['advanced']))
					{
						foreach ($page['advanced'] AS $adv_group => $adv_settings)
						{
							if (!empty($adv_settings))
							{
								foreach ($adv_settings AS $adv_varname => $adv_value)
								{
									switch ($adv_varname)
									{
										case 'portal_navigation_excludepages':
											$page['advanced'][$adv_group][$adv_varname] = explode(',', $adv_value);
										break;

										case 'portal_navigation_addpages':
										case 'portal_threadids':
											if (!is_array($adv_value))
											{
												$page['advanced'][$adv_group][$adv_varname] = unserialize($adv_value);
											}
										break;

										case 'portal_threads_forumids':
										case 'portal_news_forumid':
										case 'portal_poll_forumid':
										case 'portal_navigation_excludepages':
											$page['advanced'][$adv_group][$adv_varname] = ($adv_value) ? explode(',', $adv_value) : array();
										break;
									}
								}
							}
						}
					}

					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_pages SET
							modules = '" . $db->escape_string(serialize($layout)) . "',
							advanced = '" . $db->escape_string(serialize($page['advanced'])) . "'
						WHERE pageid = $page[pageid]
					");
				}

				// Pages table alterations
				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_pages
						CHANGE modules modules TEXT NOT NULL,
						CHANGE advanced advanced TEXT NOT NULL
				");

				$stepphrase .= 'Finished adv_pages table alterations.<br /><br />';

				require_once(DIR . '/includes/functions_misc.php');

				$modoptfiles = array();
				foreach ($vba_modules AS $modid => $module)
				{
					if ($module['options'])
					{
						// Distinguish between the parent and child
						if ($module['parent'])
						{
							$module['filename'] .= '-child';
						}
						$modoptfiles[$module['filename']] = $module['options'];
					}
				}

				// Update templatelist's to use new format
				foreach ($modcache AS $modid => $modinfo)
				{
					$modupdatequery = array();
					if (trim($modinfo['templatelist']))
					{
						$tlist = array_map('trim', explode(',', $modinfo['templatelist']));

						if ($modinfo['parent'])
						{
							$modinfo['filename'] .= '-child';
						}

						// Add new templates
						switch ($modinfo['filename'])
						{
							case 'latesttopics.php':
								$tlist = array_diff($tlist, array(
										'adv_portal_latesttopicbits',
										'adv_portal_latestthreads_head',
										'adv_portal_latesttopics'
								));
								$tlist[] = 'adv_portal_recthreads_lean';
								$tlist[] = 'adv_portal_recthreads_exp';
								$tlist[] = 'adv_portal_recthreads_exp_head';
							break;

							case 'news.php':
								if ($modinfo['parent'])
								{
									$tlist = array_diff($tlist, array(
											'adv_portal_news_archive_head',
											'adv_portal_news_archivebits'
									));
									$tlist[] = 'adv_portal_archivebits_exp';
									$tlist[] = 'adv_portal_archivebits_exp_head';
									$tlist[] = 'adv_portal_archivebits_lean';
								}
							break;

							case 'welcomeblock.php':
								unset($tlist['adv_portal_welcomeblock']);

								$tlist[] = 'adv_portal_welcomeblock_lean';
								$tlist[] = 'adv_portal_welcomeblock_expanded';
							break;
						}

						$tlist = implode("\r\n", $tlist);

						$modupdatequery[] = "templatelist = '" . $db->escape_string($tlist) . "'";
					}

					// Change from serialized array to bitfield
					if ($modinfo['inctype'] == 'bbcode')
					{
						$modinfo['options'] = unserialize($modinfo['options']);
						$newopts = convert_array_to_bits($modinfo['options'], $vba_bbc_modint);

						$modupdatequery[] = "options = '$newopts'";
					}

					if ($modinfo['identifier'] AND $modinfo['filename'])
					{
						$modupdatequery[] = "options = '" . intval($modoptfiles[$modinfo['filename']]) . "'";
					}

					if (!empty($modupdatequery))
					{
						$db->query_write("
							UPDATE " . TABLE_PREFIX . "adv_modules SET
								" . implode(', ', $modupdatequery) . "
							WHERE modid = $modid
						");
					}
				}


				// Delete old templates from master style
				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "template
					WHERE title IN(
						'adv_portal_latesttopicbits',
						'adv_portal_latestthreads_head',
						'adv_portal_latesttopics',
						'adv_portal_news_archive_head',
						'adv_portal_news_archivebits',
						'adv_portal_welcomeblock'
					) AND styleid = '-1'
				");

				// Update the latest topics module to use recentthreads.php
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET filename = 'recentthreads.php' WHERE filename = 'latesttopics.php'");

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET options = 8 WHERE cleanoutput = 1");

				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_modules
						DROP modcol,
						DROP displayorder,
						DROP cleanoutput,
						CHANGE options options SMALLINT(3) NOT NULL
				");

				$stepphrase .= 'Finished adv_modules table alterations.<br /><br />';


				// Add homepage cache
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title, unserialize) VALUES ('adv_portal_home', 1)");

				$stepphrase .= 'Added homepage cache datastore entry.<br /><br />';

				// Update forumid settings to serialize instead of explode
				$getforumsettings = $db->query_read("
					SELECT varname, grouptitle, value
					FROM " . TABLE_PREFIX . "adv_setting
					WHERE varname IN('portal_threads_forumids', 'portal_news_forumid', 'portal_poll_forumid', 'portal_navigation_excludepages')
				");
				while ($forumsetting = $db->fetch_array($getforumsettings))
				{
					$forumsetting['value'] = ($forumsetting['value']) ? explode(',', $forumsetting['value']) : array();
					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_setting SET
							value = '" . $db->escape_string(serialize($forumsetting['value'])) . "'
						WHERE varname = '$forumsetting[varname]'
							AND grouptitle = '$forumsetting[grouptitle]'
					");
				}

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET serialize = 1 WHERE varname IN('portal_threads_forumids', 'portal_threadids')");

				// Update module shell template name
				$db->query_write("
					UPDATE " . TABLE_PREFIX . "template SET
						title = 'adv_portal_module_wrapper'
					WHERE title = 'adv_portal_module_shell'
				");

				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "phrase
					WHERE fieldname = 'adv_portal'
						AND varname IN('news_archive', 'on', 'quick_moderation', 'x_attachment', 'x_events', 'x_posts', 'x_threads', 'x_users')
				");

				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "phrase
					WHERE fieldname = 'adv_portal_cp'
						AND varname IN('hide_module_settings', 'module_identifier', 'module_name', 'module_shell_template_options', 'options_apply_to_module_shell', 'or_template_to_include', 'page_template', 'page_template_description', 'show_module_settings', 'template_note_prefixes', 'templates_used_note', 'this_what_used_identify_module',	'update_all_pages', 'use_module_shell_template')
				");


				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "phrase
					WHERE fieldname = 'error' AND varname IN('adv_portal_must_choose_include')
				");

				$stepphrase .= 'Removed old phrases.<br /><br />';

			case '3.0 Beta 1':
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules ADD altshell VARCHAR(255) NOT NULL AFTER useshell");

				// This part only needs to be run if they were actually running the beta
				if ($vcheck['value'] == '3.0 Beta 1')
				{
					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET options = options+16 WHERE filename IN('recentthreads.php', 'currentpoll.php', 'news.php')");

					$colsetting = $db->query_first("SELECT value FROM " . TABLE_PREFIX . "adv_setting WHERE varname = 'portal_column_array'");
					$colvals = explode("\r\n", $colsetting['value']);

					$newcolumns = array();
					if (!empty($colvals))
					{
						foreach ($colvals AS $coldata)
						{
							$coldata = explode('|', $coldata);

							if (intval($coldata[0]) AND trim($coldata[1]))
							{
								$newcolumns[$coldata[0]] = $coldata[1];
							}
						}
					}

					$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET value = '" . $db->escape_string(serialize($newcolumns)) . "' WHERE varname = 'portal_column_array'");
				}

				// Turn the module function setting off for upgrades so custom modules won't break
				$mainsettings['adv_portal_main']['portal_use_module_function']['value'] = 0;

			case '3.0 RC1':

				// Make sure the custom page content module was not deactivated in a previous version
				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET active = 1 WHERE inctype = 'custom'");

			case '3.0 RC2':

				$stepphrase .= 'Adding index on poll table.<br /><br />';
				vbflush();
				add_table_index('poll', 'dateline');

				kill_template('recthreads_expanded');
				kill_phrase('discuss_this_poll');

				// Could still be around from old CMPS versions
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle = 'adv_portal_misc'");
				$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle = 'adv_portal_misc'");

				$db->reporterror = 0; // not sure how people are getting dupe errors, but they are
				$db->query_write("INSERT INTO " . TABLE_PREFIX . "datastore (title, data, unserialize) VALUES ('adv_portal_pars', '', 1)");
				$db->reporterror = 1;

				$db->query_write("UPDATE " . TABLE_PREFIX . "datastore SET title = 'adv_portal_stat', data = '' WHERE title = 'adv_portal_tpst'");
				$stepphrase .= 'Renamed the stats module datastore title.<br /><br />';

				$getmods = array();
				foreach ($vba_modules AS $modid => $module)
				{
					if ($module['identifier'])
					{
						$getmods[] = "'$module[identifier]'";
					}
				}

				// Update Module Links
				$querymods = $db->query_read("SELECT * FROM " . TABLE_PREFIX . "adv_modules WHERE identifier IN(" . implode(', ', $getmods) . ")");
				while ($mods = $db->fetch_array($querymods))
				{
					$linkcheck = strstr($mods['link'], '$session[sessionurl]');
					$newlink = '';

					if ($linkcheck)
					{
						if ($linkcheck == '$session[sessionurl]')
						{
							$newlink = '{$vbulletin->session->vars[sessionurl_q]}';
							$findtext = '?$session[sessionurl]';
						}
						else
						{
							$newlink = '{$vbulletin->session->vars[sessionurl]}';
							$findtext = '$session[sessionurl]';
						}

						$db->query_write("
							UPDATE " . TABLE_PREFIX . "adv_modules SET
								link = '" . str_replace($findtext, $newlink, $mods['link']) . "'
								WHERE modid = $mods[modid]
						");
					}
				}

				$stepphrase .= 'Updated module links to replace $session[sessionurl] with {$vbulletin->session->vars[sessionurl].<br /><br />';

				// Insert tags module
				$tagsmod = $vba_modules['15'];

				$tagsmod['userperms'] = implode(',', array_keys($vbulletin->usergroupcache));
				$tagsmod['templatelist'] = str_replace(' ', "\r\n", $tagsmod['templatelist']);
				unset($tagsmod['cssfiles']); // remove the css field since that hasn't been added yet

				$db->query_write(fetch_query_sql($tagsmod, 'adv_modules'));

				$stepphrase .= 'Inserted &quot;Popular Tags&quot; module.<br /><br />';

			case '3.0.0':

				// Update modules to add security token
				$querymods = $db->query_read("SELECT modid, formcode FROM " . TABLE_PREFIX . "adv_modules WHERE formcode LIKE '%<form%'");
				while ($mods = $db->fetch_array($querymods))
				{
					if (strpos($mods['formcode'], 'securitytoken') === false)
					{
						$mods['formcode'] .= '<input type="hidden" name="securitytoken" value="{$vbulletin->userinfo[securitytoken]}" />';
						$db->query_write("
							UPDATE " . TABLE_PREFIX . "adv_modules SET
								formcode = '" . $db->escape_string($mods['formcode']) . "'
							WHERE modid = $mods[modid]
						");
					}
				}

			case '3.0.1':

				// Alter page table
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages CHANGE useshell useshell smallint(3) unsigned NOT NULL default '0'");

			case '3.1.0':

				$db->query_write("
					CREATE TABLE " . TABLE_PREFIX . "adv_pages_user (
					  pageid int(10) unsigned NOT NULL default '0',
					  userid int(10) unsigned NOT NULL default '0',
					  layout text NOT NULL,
					  UNIQUE KEY pageid (pageid,userid)
					) $enginevar=MyISAM
				");

				$stepphrase .= 'Created adv_pages_user table.<br /><br />';

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_modules ADD dyna_prefix VARCHAR(50) NOT NULL");
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD customize SMALLINT(3) UNSIGNED NOT NULL DEFAULT '0' AFTER useshell");

				$stepphrase .= 'Updated new columns.<br /><br />';

				$db->query_write("UPDATE " . TABLE_PREFIX . "adv_setting SET grouptitle = '' WHERE varname = 'portal_replaceadmin' AND grouptitle = 'adv_portal_main'");

			case '3.2.0':

				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages ADD dateline INT(10) UNSIGNED NOT NULL DEFAULT '0'");
				$db->query_write("ALTER TABLE " . TABLE_PREFIX . "adv_pages_user ADD dateline INT(10) UNSIGNED NOT NULL DEFAULT '0'");

			case '3.2.1':
			case '3.2.2':
			case '3.2.3':

				// Update vB3 modules to turn the 'Wrap a Table Around Content' setting on
				$shellupdate = '';
				$getmodules = $db->query_read("
					SELECT modid
					FROM " . TABLE_PREFIX . "adv_modules
					WHERE filename NOT IN('onlineusers.php', 'onlineusers.php', 'minicalendar.php', 'news.php', 'recentthreads.php', 'stats.php', 'currentpoll.php', 'moderate.php', 'welcomeblock.php', 'search', 'news.php', 'birthdays.php', 'navigation.php', 'popular_tags.php')
						AND (useshell & 1)
						AND inctype IN('template', 'php_file')
				");
				while ($mod = $db->fetch_array($getmodules))
				{
					$shellupdate .= $mod['modid'] . ', ';
				}

				if ($shellupdate)
				{
					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_modules SET
							useshell = useshell + 4
						WHERE modid IN(" . substr($shellupdate, 0, -2) . ")
					");
				}

			case '4.0.0 Beta 1':

				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_modules
					ADD cssfiles TEXT NOT NULL
					AFTER templatelist
				");

				foreach ($vba_modules AS $mod)
				{
					if ($mod['cssfiles'])
					{
						$db->query_write("UPDATE " . TABLE_PREFIX . "adv_modules SET cssfiles = '$mod[cssfiles]' WHERE filename = '$mod[filename]'");
					}
				}

				$stepphrase .= 'Added new CSS File setting for modules and updated default modules.<br /><br />';

				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "plugin
					WHERE devkey IN('adv_cmps_error', 'adv_cmps_ajaxspacer')
				");

				$stepphrase .= 'Removed depreciated plugins.<br /><br />';

			case '4.0.0 Beta 2':

				$db->query_write("
					ALTER TABLE " . TABLE_PREFIX . "adv_pages
						ADD navpos VARCHAR(50) NOT NULL,
						ADD navchildren SMALLINT(3) UNSIGNED NOT NULL DEFAULT '0'
				");
				$stepphrase .= 'Added \'navpos\' and \'navchildren\' columns to \'adv_pages\' table.<br /><br />';

				$vbsetting_insert = '';
				foreach ($vba_vbsettings AS $vbsetting_var)
				{
					$vbsetting_insert .= "(
						'$vbsetting_var',
						'version',
						'',
						'',
						'',
						'1000',
						'0',
						'1',
						'free',
						'" . PRODUCT_CODE . "',
						'',
						'0'
					), ";
				}

				$db->query_write("
					INSERT INTO " . TABLE_PREFIX . "setting
						(varname, grouptitle, value, defaultvalue, optioncode, displayorder, advanced, volatile, datatype, product, validationcode, blacklist)
					VALUES " . substr($vbsetting_insert, 0, strlen($vbsetting_insert) - 2)
				);

				build_options();
				$stepphrase .= 'Added hidden vBulletin settings.<br /><br />';

			case '4.0.0 RC1':

				// Make sure content.php has been added to the replacement settings
				$repsettings = array();
				$getrsettings = $db->query_read("
					SELECT varname, value FROM " . TABLE_PREFIX . "adv_setting
					WHERE varname IN('global_header_replace', 'global_navbar_replace')
					AND grouptitle = 'adv_global'
				");
				while ($rsettings = $db->fetch_array($getrsettings))
				{
					if ($rsettings['value'])
					{
						$repsettings[$rsettings['varname']] = explode("\r\n", $rsettings['value']);
					}
				}
				if (!empty($repsettings))
				{
					foreach ($repsettings AS $rvarname => $rvalues)
					{
						if (!in_array('content.php', $rvalues))
						{
							$rvalues[] = 'content.php';

							$db->query_write("
								UPDATE " . TABLE_PREFIX . "adv_setting SET
									value = '" . $db->escape_string(implode("\r\n", $rvalues)) . "'
								WHERE varname = '$rvarname'
									AND grouptitle = 'adv_global'
							");
						}
					}
				}

			// #####
			case '4.0.1':

				$phrasetypeid = 'adv_portal';
				$varname = 'show_printable_version';
				kill_phrase();
				
				$varname = 'portal_news_showprintable';
				$grouptitle = 'adv_portal_news';
				kill_setting();


				$killtemplates = array(
					'adv_portal_navigationbits',
					'adv_portal_newsbits_attach_inline',
					'adv_portal_newsbits_attach_thumb',
					'adv_portal_polloption',
					'adv_portal_polloption_multiple',
					'adv_portal_pollresult',
					'forumhome_loggedinuser'
				);

				$mod_assoc = array();
				foreach ($vba_modules AS $modid => $mod)
				{
					if ($mod['filename'] == 'news.php' AND $mod['parent'])
					{
						$mod['filename'] = 'news.php_archive';
					}
					else if ($mod['filename'] == 'onlineusers.php')
					{
						$mod['filename'] = $mod['filename'] . '_' . $mod['identifier'];
					}

					$mod_assoc[$mod['filename']] = $modid;
				}

				$getmodules = $db->query_read("
					SELECT modid, filename, templatelist, parent
					FROM " . TABLE_PREFIX . "adv_modules
				");
				while ($module = $db->fetch_array($getmodules))
				{
					$module['templatelist'] = explode("\r\n", $module['templatelist']);
	
					if ($module['filename'] == 'news.php' AND $module['parent'])
					{
						$module['filename'] = 'news.php_archive';
					}
					else if ($module['filename'] == 'online.php')
					{
						$module['filename'] = $module['filename'] . '_' . $module['identifier'];
					}

					if ($mod_assoc[$module['filename']] AND $vba_modules[$mod_assoc[$module['filename']]]['templatelist'])
					{
						$module['templatelist'] = array_merge($module['templatelist'], explode(" ", $vba_modules[$mod_assoc[$module['filename']]]['templatelist']));
					}
	
					$module['templatelist'] = array_unique(array_diff($module['templatelist'], $killtemplates));
	
					$db->query_write("
						UPDATE " . TABLE_PREFIX . "adv_modules SET
							templatelist = '" . $db->escape_string(implode("\r\n", $module['templatelist'])) . "'
						WHERE modid = $module[modid]
					");
	
				}
				
				unset($killtemplates[6]); // unset the forumhome_loggedin template

				$db->query_write("
					DELETE FROM " . TABLE_PREFIX . "template
					WHERE title IN('" . implode("', '", $killtemplates) . "')
						AND styleid = '-1'
				");
	
				$stepphrase .= 'Removed depreciated templates.';
				
			// #####
			case '4.1.0':
				// nothing to do


			// #####
			default:

				// ##### Templates
				insert_all_templates();

				$rebuildtemp = true;

				$stepphrase .= 'Updated templates.<br /><br />';
				vbflush();

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "adv_setting SET
						value = '$version'
					WHERE varname = 'portal_version'
				");

				$db->query_write("
					UPDATE " . TABLE_PREFIX . "product SET
						version = '" . $version . "',
						url = 'http://www.vbadvanced.com'
					WHERE productid = '" . PRODUCT_CODE . "'
				");

				$stepphrase .= 'Updated version number.<br /><br />';

				// Update the settings, and phrases are handled within the function too
				rebuild_all_settings();

				$stepphrase .= 'Added / updated phrases.<br /><br />';
				$stepphrase .= 'Updated current settings and added any new ones.<br /><br />';

				insert_plugins();

				update_page_cache();
				update_homepage_cache();

				update_module_cache();

				if (in_array($vcheck['value'], array('1.0.0', '1.0.1', 'RC2')))
				{
					construct_hidden_code('redirect', 'finished');
					$nextdo = 'alttables';
				}
				else
				{
					$nextdo = 'finished';
				}

		}
	}

	print_install_table_end();
}

// ##### Uninstall ############################################################
if ($_REQUEST['do'] == 'uninstall')
{
	$step = $_REQUEST['step'];
	$forumsoff = intval($_REQUEST['forumsoff']);

	print_install_table_start('vBadvanced ' . $scriptname . ' Uninstall', 'uninstall');

	$db->reporterror = 0;

	switch ($step)
	{
		case 1:
			$stepphrase = 'We\'re sorry you didn\'t like vBadvanced ' . $scriptname . '. Running this script will remove all changes that were made for vBadvanced ' . $scriptname . '.</div>';
		break;

		case 2:

			if ($vbulletin->options['bbactive'])
			{
				print_description_row('Please turn your forums off before proceeding', '', 2, 'thead');
				print_textarea_row('Forums closed message:', 'closedmessage', $vbulletin->options['bbclosedreason'], 4, 40, 1, 0);
				construct_hidden_code('redirect', 'uninstall');
				$nextdo = 'closeforums';
			}
			else
			{
				print_cp_redirect($scriptfile . '.php?do=uninstall&amp;step=3');
			}

		break;

		case 3:

			$db->query_write("DROP TABLE " . TABLE_PREFIX . "adv_modules");
			$db->query_write("DROP TABLE " . TABLE_PREFIX . "adv_pages");
			$db->query_write("DROP TABLE " . TABLE_PREFIX . "adv_pages_user");

			$stepphrase .= 'Removed tables.<br /><br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrase WHERE fieldname IN('adv_portal','adv_portal_cp')");

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "phrasetype WHERE fieldname IN('adv_portal','adv_portal_cp')");

			$db->query_write("
				ALTER TABLE " . TABLE_PREFIX . "language
					DROP phrasegroup_adv_portal,
					DROP phrasegroup_adv_portal_cp
			");

			$stepphrase .= 'Removed phrases.<br /><br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "product WHERE productid = '" . PRODUCT_CODE . "'");

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "plugin WHERE devkey IN('" . implode("', '", array_keys($vba_plugins)) . "') AND product = 'adv_cmps'");

			$stepphrase .= 'Remove product and plugins.<br /><br />';

			$db->query_write("ALTER TABLE " . TABLE_PREFIX . "session DROP newposts");
			$stepphrase .= 'Altered session table to remove newposts field.<br /><br />';

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "template WHERE product = 'adv_cmps'");

			$stepphrase .= 'Removed templates.<br /><br />';

			unset($mainsettings['adv_global']);
			unset($adv_settinggroups['adv_global']);

			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_setting WHERE grouptitle LIKE 'adv_portal%'");
			$db->query_write("DELETE FROM " . TABLE_PREFIX . "adv_settinggroup WHERE grouptitle LIKE 'adv_portal%'");

			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "setting
				WHERE varname IN('" . implode("', '", $vba_vbsettings) . "')
					AND grouptitle = 'version'
					AND product = '" . PRODUCT_CODE . "'
			");

			$stepphrase .= 'Removed settings.<br /><br />';

			$db->query_write("
				DELETE FROM " . TABLE_PREFIX . "datastore
				WHERE title IN(
					'adv_portal_opts',
					'adv_modules',
					'adv_portal_page',
					'adv_portal_pars',
					'adv_portal_stat',
					'adv_portal_home',
					'adv_portal_cale'
			)");

			vBulletinHook::build_datastore($db);

			$stepphrase .= 'Removed fields from the datastore table.<br />';

		break;

		case 4:
			$stepphrase = 'Removed index added on user table.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "user DROP INDEX (posts)");
		break;

		case 5:
			$stepphrase = 'Removed index added on poll table.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "poll DROP INDEX (dateline)");
		break;

		case 6:
			$stepphrase = 'Removed index added on thread table.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "thread DROP INDEX (lastpost)");
		break;

		case 7:
			$stepphrase = 'Removed index added on post table.<br />';
			vbflush();
			$db->query_write("ALTER TABLE" . TABLE_PREFIX . "post DROP INDEX (dateline)");
			$nextstep = 'finished';

			if ($forumsoff)
			{
				$db->query_write("UPDATE " . TABLE_PREFIX . "setting SET value = 1 WHERE varname = 'bbactive'");
				build_options();

				$stepphrase .= '<br />Your forums have now been turned back on.';
			}
		break;

		case 'finished':

			$stepphrase = 'vBadvanced ' . $scriptname . ' Successfully Uninstalled.<br /> <br /><a href="index.php"><strong>Log Into Admin CP --&gt;</strong></a><br /><br /><a href="' . $scriptfile . '.php"><strong>Click here to re-install --&gt;</strong></a>';
			$nocontinue = 1;

		break;
	}

	print_install_table_end();
}

// ##### Rebuild Settings #####################################################
if ($_REQUEST['do'] == 'rebuildsettings')
{
	print_install_table_start();

	rebuild_all_settings();

	$stepphrase = 'Settings rebuilt.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}

// ##### Reinstall plugins ####################################################
if ($_REQUEST['do'] == 'updateplugins')
{
	print_install_table_start();

	insert_plugins();

	$stepphrase = 'Plugins reinstalled.<br /><br />';
	$nextdo = 'finished';

	print_install_table_end();
}


print_cp_footer();

?>